package com.zurrtum.create.client.content.logistics.depot;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.logistics.depot.EjectorBlockEntity;
import com.zurrtum.create.content.logistics.depot.EntityLauncher;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import com.zurrtum.create.infrastructure.packet.c2s.EjectorPlacementPacket;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_239.class_240;
import net.minecraft.class_2390;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class EjectorTargetHandler {

    static class_2338 currentSelection;
    static class_1799 currentItem;
    static long lastHoveredBlockPos = -1;
    static EntityLauncher launcher;

    public static class_1269 rightClickingBlocksSelectsThem(class_1937 world, class_746 player, class_1268 hand, class_3965 ray) {
        if (currentItem == null)
            return null;
        class_2338 pos = ray.method_17777();
        if (player.method_7325() || !player.method_5715())
            return null;

        String key = "weighted_ejector.target_set";
        player.method_7353(CreateLang.translateDirect(key).method_27692(class_124.field_1065), true);
        currentSelection = pos;
        launcher = null;
        return class_1269.field_5812;
    }

    public static boolean leftClickingBlocksDeselectsThem(class_746 player, class_2338 pos) {
        if (currentItem == null)
            return false;
        if (!player.method_5715())
            return false;
        if (pos.equals(currentSelection)) {
            currentSelection = null;
            launcher = null;
            return true;
        }
        return false;
    }

    public static void flushSettings(class_2338 pos) {
        class_746 player = class_310.method_1551().field_1724;
        String key = "weighted_ejector.target_not_valid";
        class_124 colour = class_124.field_1068;

        if (currentSelection == null)
            key = "weighted_ejector.no_target";

        class_2350 validTargetDirection = getValidTargetDirection(pos);
        if (validTargetDirection == null) {
            player.method_7353(CreateLang.translateDirect(key).method_27692(colour), true);
            currentItem = null;
            currentSelection = null;
            return;
        }

        key = "weighted_ejector.targeting";
        colour = class_124.field_1060;

        player.method_7353(
            CreateLang.translateDirect(key, currentSelection.method_10263(), currentSelection.method_10264(), currentSelection.method_10260())
                .method_27692(colour), true
        );

        class_2338 diff = pos.method_10059(currentSelection);
        int h = Math.abs(diff.method_10263() + diff.method_10260());
        int v = -diff.method_10264();

        player.field_3944.method_52787(new EjectorPlacementPacket(h, v, pos, validTargetDirection));
        currentSelection = null;
        currentItem = null;

    }

    public static class_2350 getValidTargetDirection(class_2338 pos) {
        if (currentSelection == null)
            return null;
        if (VecHelper.onSameAxis(pos, currentSelection, class_2351.field_11052))
            return null;

        int xDiff = currentSelection.method_10263() - pos.method_10263();
        int zDiff = currentSelection.method_10260() - pos.method_10260();
        int max = AllConfigs.server().kinetics.maxEjectorDistance.get();

        if (Math.abs(xDiff) > max || Math.abs(zDiff) > max)
            return null;

        if (xDiff == 0)
            return class_2350.method_10156(zDiff < 0 ? class_2352.field_11060 : class_2352.field_11056, class_2351.field_11051);
        if (zDiff == 0)
            return class_2350.method_10156(xDiff < 0 ? class_2352.field_11060 : class_2352.field_11056, class_2351.field_11048);

        return null;
    }

    public static void tick(class_310 mc) {
        class_1799 heldItemMainhand = mc.field_1724.method_6047();
        if (!heldItemMainhand.method_31574(AllItems.WEIGHTED_EJECTOR)) {
            currentItem = null;
        } else {
            if (heldItemMainhand != currentItem) {
                currentSelection = null;
                currentItem = heldItemMainhand;
            }
            drawOutline(mc.field_1687, currentSelection);
        }

        boolean wrench = heldItemMainhand.method_31574(AllItems.WRENCH);
        if (wrench) {
            checkForWrench(mc);
        }
        drawArc(mc, wrench);
    }

    protected static void drawArc(class_310 mc, boolean wrench) {
        if (currentSelection == null)
            return;
        if (currentItem == null && !wrench)
            return;

        class_239 objectMouseOver = mc.field_1765;
        if (!(objectMouseOver instanceof class_3965 blockRayTraceResult))
            return;
        if (blockRayTraceResult.method_17783() == class_240.field_1333)
            return;

        class_2338 pos = blockRayTraceResult.method_17777();
        if (!wrench)
            pos = pos.method_10093(blockRayTraceResult.method_17780());

        int xDiff = currentSelection.method_10263() - pos.method_10263();
        int yDiff = currentSelection.method_10264() - pos.method_10264();
        int zDiff = currentSelection.method_10260() - pos.method_10260();
        int validX = Math.abs(zDiff) > Math.abs(xDiff) ? 0 : xDiff;
        int validZ = Math.abs(zDiff) < Math.abs(xDiff) ? 0 : zDiff;

        class_2338 validPos = currentSelection.method_10069(validX, yDiff, validZ);
        class_2350 d = getValidTargetDirection(validPos);
        if (d == null)
            return;
        if (launcher == null || lastHoveredBlockPos != pos.method_10063()) {
            lastHoveredBlockPos = pos.method_10063();
            launcher = new EntityLauncher(Math.abs(validX + validZ), yDiff);
        }

        double totalFlyingTicks = launcher.getTotalFlyingTicks() + 3;
        int segments = (((int) totalFlyingTicks) / 3) + 1;
        double tickOffset = totalFlyingTicks / segments;
        boolean valid = xDiff == validX && zDiff == validZ;
        int intColor = valid ? 0x9ede73 : 0xff7171;
        class_2390 data = new class_2390(intColor, 1);
        class_638 world = mc.field_1687;

        class_238 bb = new class_238(0, 0, 0, 1, 0, 1).method_996(currentSelection.method_10069(-validX, -yDiff, -validZ));
        Outliner.getInstance().chaseAABB("valid", bb).colored(intColor).lineWidth(1 / 16f);

        for (int i = 0; i < segments; i++) {
            double ticks = ((AnimationTickHolder.getRenderTime() / 3) % tickOffset) + i * tickOffset;
            class_243 vec = launcher.getGlobalPos(ticks, d, pos).method_1031(xDiff - validX, 0, zDiff - validZ);
            world.method_8406(data, vec.field_1352, vec.field_1351, vec.field_1350, 0, 0, 0);
        }
    }

    private static void checkForWrench(class_310 mc) {
        class_239 objectMouseOver = mc.field_1765;
        if (!(objectMouseOver instanceof class_3965 result))
            return;
        class_2338 pos = result.method_17777();

        class_2586 be = mc.field_1687.method_8321(pos);
        if (!(be instanceof EjectorBlockEntity)) {
            lastHoveredBlockPos = -1;
            currentSelection = null;
            return;
        }

        if (lastHoveredBlockPos == -1 || lastHoveredBlockPos != pos.method_10063()) {
            EjectorBlockEntity ejector = (EjectorBlockEntity) be;
            if (!ejector.getTargetPosition().equals(ejector.method_11016()))
                currentSelection = ejector.getTargetPosition();
            lastHoveredBlockPos = pos.method_10063();
            launcher = null;
        }

        if (lastHoveredBlockPos != -1)
            drawOutline(mc.field_1687, currentSelection);
    }

    public static void drawOutline(class_638 world, class_2338 pos) {
        if (pos == null)
            return;
        class_2680 state = world.method_8320(pos);
        class_265 shape = state.method_26218(world, pos);
        class_238 boundingBox = shape.method_1110() ? new class_238(class_2338.field_10980) : shape.method_1107();
        Outliner.getInstance().showAABB("target", boundingBox.method_996(pos)).colored(0xffcb74).lineWidth(1 / 16f);
    }

}
