package com.zurrtum.create.client.content.logistics.factoryBoard;

import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.PonderRenderTypes;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.client.foundation.render.RenderTypes;
import com.zurrtum.create.content.logistics.factoryBoard.*;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlockEntity;
import com.zurrtum.create.content.redstone.link.RedstoneLinkBlockEntity;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_765;

public class FactoryPanelRenderer extends SmartBlockEntityRenderer<FactoryPanelBlockEntity, FactoryPanelRenderer.FactoryPanelRenderState> {
    public FactoryPanelRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public FactoryPanelRenderState createRenderState() {
        return new FactoryPanelRenderState();
    }

    @Override
    public void updateRenderState(
        FactoryPanelBlockEntity be,
        FactoryPanelRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        super.updateRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        List<SingleFactoryPanelRenderState> panels = new ArrayList<>();
        boolean[] layers = new boolean[3];
        for (ServerFactoryPanelBehaviour behaviour : be.panels.values()) {
            if (behaviour.isActive()) {
                boolean bulb = behaviour.getAmount() > 0;
                boolean target = !behaviour.targetedBy.isEmpty() || !behaviour.targetedByLinks.isEmpty();
                if (!target && !bulb) {
                    continue;
                }
                SingleFactoryPanelRenderState panel = new SingleFactoryPanelRenderState();
                boolean missingAddress = behaviour.isMissingAddress();
                float offsetX = behaviour.slot.xOffset * .5f;
                float offsetY = behaviour.slot.yOffset * .5f;
                float glow = behaviour.bulb.getValue(tickProgress);
                if (target) {
                    layers[0] = true;
                    panel.offsetX = offsetX + 0.25f;
                    panel.offsetY = offsetY + 0.25f;
                    List<PathRenderState> paths = panel.paths = new ArrayList<>();
                    class_1937 world = behaviour.getWorld();
                    FactoryPanelPosition to = behaviour.getPanelPosition();
                    FactoryPanelBehaviour fromBehaviour = be.getBehaviour(FactoryPanelBehaviour.getTypeForSlot(behaviour.slot));
                    class_243 start = fromBehaviour.getSlotPositioning().getLocalOffset(state.blockState).add(class_243.method_24954(state.pos));
                    for (FactoryPanelConnection connection : behaviour.targetedBy.values()) {
                        List<class_2350> path = connection.getPath(world, state.blockState, to, start);
                        if (path.isEmpty()) {
                            continue;
                        }
                        paths.add(getPathRenderState(behaviour, connection, path, world, state.blockState, missingAddress, glow));
                    }
                    for (FactoryPanelConnection connection : behaviour.targetedByLinks.values()) {
                        List<class_2350> path = connection.getPath(world, state.blockState, to, start);
                        if (path.isEmpty()) {
                            continue;
                        }
                        paths.add(getPathRenderState(behaviour, connection, path, world, state.blockState, missingAddress, glow));
                    }
                }
                if (bulb) {
                    panel.bulb = getBulbRenderState(behaviour, state.blockState, missingAddress, offsetX, offsetY, glow, layers);
                }
                panels.add(panel);
            }
        }
        if (panels.isEmpty()) {
            return;
        }
        state.xRot = FactoryPanelBlock.getXRot(state.blockState) + class_3532.field_29844 / 2;
        state.yRot = FactoryPanelBlock.getYRot(state.blockState);
        state.panels = panels;
        if (layers[0]) {
            state.cutout = class_1921.method_23579();
        }
        if (layers[1]) {
            state.translucent1 = PonderRenderTypes.translucent();
        }
        if (layers[2]) {
            state.translucent2 = RenderTypes.translucent();
            state.additive = RenderTypes.additive();
        }
    }

    @Override
    public void render(FactoryPanelRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        super.render(state, matrices, queue, cameraState);
        if (state.panels != null) {
            if (state.cutout != null) {
                queue.method_73483(matrices, state.cutout, state::renderCutout);
            }
            if (state.translucent1 != null) {
                queue.method_73483(matrices, state.translucent1, state::renderTranslucent1);
            }
            if (state.additive != null) {
                queue.method_73483(matrices, state.translucent2, state::renderTranslucent2);
                queue.method_73483(matrices, state.additive, state::renderAdditive);
            }
        }
    }

    public static BulbRenderState getBulbRenderState(
        ServerFactoryPanelBehaviour behaviour,
        class_2680 blockState,
        boolean missingAddress,
        float offsetX,
        float offsetY,
        float glow,
        boolean[] layers
    ) {
        BulbRenderState state = new BulbRenderState();
        PartialModel partial = behaviour.redstonePowered || missingAddress ? AllPartialModels.FACTORY_PANEL_RED_LIGHT : AllPartialModels.FACTORY_PANEL_LIGHT;
        state.model = CachedBuffers.partial(partial, blockState);
        state.offsetX = offsetX;
        state.offsetY = offsetY;
        if (glow < 0.125f) {
            layers[1] = true;
            return state;
        }
        layers[2] = true;
        state.glow = true;
        glow = (float) (1 - (2 * Math.pow(glow - .75f, 2)));
        glow = class_3532.method_15363(glow, -1, 1);
        state.color = (int) (200 * glow);
        return state;
    }

    public static PathRenderState getPathRenderState(
        ServerFactoryPanelBehaviour behaviour,
        FactoryPanelConnection connection,
        List<class_2350> path,
        class_1937 world,
        class_2680 blockState,
        boolean missingAddress,
        float glow
    ) {
        PathRenderState state = new PathRenderState();
        FactoryPanelSupportBehaviour sbe = ServerFactoryPanelBehaviour.linkAt(world, connection);
        boolean displayLinkMode = sbe != null && sbe.blockEntity instanceof DisplayLinkBlockEntity;
        boolean redstoneLinkMode = sbe != null && sbe.blockEntity instanceof RedstoneLinkBlockEntity;
        boolean pathReversed = sbe != null && !sbe.isOutput();
        int color;
        float yOffset;
        boolean dots;
        if (displayLinkMode) {
            // Display status
            color = 0x3C9852;
            dots = true;
            yOffset = 0;
        } else if (redstoneLinkMode) {
            // Link status
            color = pathReversed ? (behaviour.count == 0 ? 0x888898 : behaviour.satisfied ? 0xEF0000 : 0x580101) : (behaviour.redstonePowered ? 0xEF0000 : 0x580101);
            dots = false;
            yOffset = 0.5f;
        } else {
            // Regular ingredient status
            color = behaviour.getIngredientStatusColor();
            dots = false;
            yOffset = 1 + (behaviour.promisedSatisfied ? 1 : behaviour.satisfied ? 0 : 2);
            if (!behaviour.redstonePowered && !behaviour.waitingForNetwork && glow > 0 && !behaviour.satisfied) {
                float p = (1 - (1 - glow) * (1 - glow));
                boolean success = connection.success;
                color = Color.mixColors(color, success ? 0xEAF2EC : 0xE5654B, p);
                if (!behaviour.promisedSatisfied) {
                    yOffset += (success ? 1 : 2) * p;
                }
            }
        }
        state.shiftUV = !displayLinkMode && !redstoneLinkMode && !missingAddress && !behaviour.waitingForNetwork && !behaviour.satisfied && !behaviour.redstonePowered;
        state.color = color;
        float currentX = 0;
        float currentZ = 0;
        List<LineRenderData> lines = state.lines = new ArrayList<>();
        for (int i = 0, size = path.size(), end = size - 1; i < size; i++) {
            class_2350 direction = path.get(i);
            if (!pathReversed) {
                currentX += direction.method_10148() * .5f;
                currentZ += direction.method_10165() * .5f;
            }
            Map<class_2350, PartialModel> group = dots ? AllPartialModels.FACTORY_PANEL_DOTTED : (pathReversed ? i == end : i == 0) ? AllPartialModels.FACTORY_PANEL_ARROWS : AllPartialModels.FACTORY_PANEL_LINES;
            PartialModel partial = group.get(pathReversed ? direction : direction.method_10153());
            SuperByteBuffer model = CachedBuffers.partial(partial, blockState);
            float currentY = (yOffset + (direction.method_10161() % 2) * 0.125f) / 512f;
            lines.add(new LineRenderData(model, currentX, currentY, currentZ));
            if (pathReversed) {
                currentX += direction.method_10148() * .5f;
                currentZ += direction.method_10165() * .5f;
            }
        }
        return state;
    }

    public static class FactoryPanelRenderState extends SmartRenderState {
        public class_1921 cutout;
        public class_1921 translucent1;
        public class_1921 translucent2;
        public class_1921 additive;
        public float xRot;
        public float yRot;
        public List<SingleFactoryPanelRenderState> panels;

        public void renderCutout(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            for (SingleFactoryPanelRenderState panel : panels) {
                panel.renderPaths(matricesEntry, vertexConsumer, xRot, yRot, lightmapCoordinates);
            }
        }

        public void renderTranslucent1(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            for (SingleFactoryPanelRenderState panel : panels) {
                panel.renderBulb(false, matricesEntry, vertexConsumer, xRot, yRot, lightmapCoordinates);
            }
        }

        public void renderTranslucent2(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            for (SingleFactoryPanelRenderState panel : panels) {
                panel.renderBulb(true, matricesEntry, vertexConsumer, xRot, yRot, lightmapCoordinates);
            }
        }

        public void renderAdditive(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            for (SingleFactoryPanelRenderState panel : panels) {
                panel.renderGlow(matricesEntry, vertexConsumer, xRot, yRot);
            }
        }
    }

    public static class SingleFactoryPanelRenderState {
        public float offsetX;
        public float offsetY;
        public List<PathRenderState> paths;
        public BulbRenderState bulb;

        public void renderPaths(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer, float xRot, float yRot, int light) {
            if (paths != null) {
                for (PathRenderState path : paths) {
                    path.render(matricesEntry, vertexConsumer, xRot, yRot, offsetX, offsetY, light);
                }
            }
        }

        public void renderBulb(boolean glow, class_4587.class_4665 matricesEntry, class_4588 vertexConsumer, float xRot, float yRot, int light) {
            if (bulb != null) {
                bulb.renderBulb(glow, matricesEntry, vertexConsumer, xRot, yRot, light);
            }
        }

        public void renderGlow(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer, float xRot, float yRot) {
            if (bulb != null) {
                bulb.renderGlow(matricesEntry, vertexConsumer, xRot, yRot);
            }
        }
    }

    public static class BulbRenderState {
        public SuperByteBuffer model;
        public float offsetX;
        public float offsetY;
        public boolean glow;
        public int color;

        public void renderBulb(boolean glow, class_4587.class_4665 entry, class_4588 vertexConsumer, float xRot, float yRot, int light) {
            if (glow == this.glow) {
                model.rotateCentered(yRot, class_2350.field_11036).rotateCentered(xRot, class_2350.field_11034).rotateCentered(class_3532.field_29844, class_2350.field_11036)
                    .translate(offsetX, 0, offsetY).light(glow ? class_765.field_32767 : light)
                    .overlay(class_4608.field_21444).renderInto(entry, vertexConsumer);
            }
        }

        private void renderGlow(class_4587.class_4665 entry, class_4588 vertexConsumer, float xRot, float yRot) {
            if (glow) {
                model.rotateCentered(yRot, class_2350.field_11036).rotateCentered(xRot, class_2350.field_11034).rotateCentered(class_3532.field_29844, class_2350.field_11036)
                    .translate(offsetX, 0, offsetY).light(class_765.field_32767).color(color, color, color, 255)
                    .overlay(class_4608.field_21444).renderInto(entry, vertexConsumer);
            }
        }
    }

    public static class PathRenderState {
        public boolean shiftUV;
        public int color;
        public List<LineRenderData> lines;

        public void render(class_4587.class_4665 entry, class_4588 vertexConsumer, float xRot, float yRot, float offsetX, float offsetY, int light) {
            for (LineRenderData line : lines) {
                line.model.rotateCentered(yRot, class_2350.field_11036).rotateCentered(xRot, class_2350.field_11034).rotateCentered(class_3532.field_29844, class_2350.field_11036)
                    .translate(offsetX, 0, offsetY).translate(line.x, line.y, line.z);
                if (shiftUV) {
                    line.model.shiftUV(AllSpriteShifts.FACTORY_PANEL_CONNECTIONS);
                }
                line.model.color(color).light(light).overlay(class_4608.field_21444).renderInto(entry, vertexConsumer);
            }
        }
    }

    public record LineRenderData(SuperByteBuffer model, float x, float y, float z) {
    }
}
