package com.zurrtum.create.client.content.logistics.funnel;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.logistics.FlapStuffs;
import com.zurrtum.create.client.content.logistics.FlapStuffs.FlapsRenderState;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.content.logistics.funnel.FunnelBlock;
import com.zurrtum.create.content.logistics.funnel.FunnelBlockEntity;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_5614;
import org.jetbrains.annotations.Nullable;

public class FunnelRenderer extends SmartBlockEntityRenderer<FunnelBlockEntity, FunnelRenderer.FunnelRenderState> {
    public FunnelRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public FunnelRenderState createRenderState() {
        return new FunnelRenderState();
    }

    @Override
    public void updateRenderState(
        FunnelBlockEntity be,
        FunnelRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        super.updateRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        if (!be.hasFlap() || VisualizationManager.supportsVisualization(be.method_10997())) {
            return;
        }
        class_2350 funnelFacing = FunnelBlock.getFunnelFacing(state.blockState);
        if (funnelFacing == null) {
            return;
        }
        PartialModel partialModel = (state.blockState.getBlock() instanceof FunnelBlock ? AllPartialModels.FUNNEL_FLAP : AllPartialModels.BELT_FUNNEL_FLAP);
        SuperByteBuffer flapBuffer = CachedBuffers.partial(partialModel, state.blockState);
        float f = be.flap.getValue(tickProgress);
        state.flap = FlapStuffs.getFlapsRenderState(
            flapBuffer,
            FlapStuffs.FUNNEL_PIVOT,
            funnelFacing,
            f,
            -be.getFlapOffset(),
            state.lightmapCoordinates
        );
    }

    @Override
    public void render(FunnelRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        super.render(state, matrices, queue, cameraState);
        if (state.flap != null) {
            state.flap.render(class_1921.method_23577(), matrices, queue);
        }
    }

    public static class FunnelRenderState extends SmartRenderState {
        public FlapsRenderState flap;
    }
}
