package com.zurrtum.create.client.content.logistics.stockTicker;

import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.stockTicker.PackageOrder;
import it.unimi.dsi.fastutil.ints.*;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1799;

public record CraftableInput(Object2ObjectMap<List<class_1799>, IntList> data, boolean crafting) {
    private static final InputStrategy STACK_STRATEGY = new InputStrategy();

    public void add(List<class_1799> stacks, int index) {
        data.computeIfAbsent(stacks, CraftableInput::createIntArray).add(index);
    }

    public ObjectSet<Object2ObjectMap.Entry<List<class_1799>, IntList>> entrySet() {
        return data.object2ObjectEntrySet();
    }

    public IntSet getMissing(List<BigItemStack> inputs) {
        IntSet missing = new IntOpenHashSet();
        data.forEach((stacks, indices) -> {
            int count = stacks.getFirst().method_7947();
            int size = indices.size();
            int remaining = count * size;
            for (BigItemStack stack : inputs) {
                if (contains(stacks, stack.stack)) {
                    remaining -= stack.count;
                    if (remaining <= 0) {
                        return;
                    }
                }
            }
            missing.addAll(indices.subList(size - (remaining + count - 1) / count, size));
        });
        return missing;
    }

    public PackageOrder getPattern(List<BigItemStack> inputs) {
        List<BigItemStack> mutableInputs = BigItemStack.duplicateWrappers(inputs);
        BigItemStack empty = new BigItemStack(class_1799.field_8037, 1);
        BigItemStack[] pattern = new BigItemStack[]{empty, empty, empty, empty, empty, empty, empty, empty, empty};
        data.forEach((stacks, indices) -> {
            IntListIterator iterator = indices.iterator();
            for (BigItemStack bigItemStack : mutableInputs) {
                int count = bigItemStack.count;
                if (count > 0 && contains(stacks, bigItemStack.stack)) {
                    BigItemStack ingredient = new BigItemStack(bigItemStack.stack, 1);
                    do {
                        count -= 1;
                        pattern[iterator.nextInt()] = ingredient;
                    } while (iterator.hasNext() && count > 0);
                    bigItemStack.count = count;
                    if (!iterator.hasNext()) {
                        break;
                    }
                }
            }
        });
        return new PackageOrder(Arrays.asList(pattern));
    }

    public static CraftableInput create(boolean crafting) {
        return new CraftableInput(new Object2ObjectOpenCustomHashMap<>(STACK_STRATEGY), crafting);
    }

    public static boolean contains(List<class_1799> list, class_1799 stack) {
        for (class_1799 item : list) {
            if (class_1799.method_31577(item, stack)) {
                return true;
            }
        }
        return false;
    }

    private static IntArrayList createIntArray(List<class_1799> stacks) {
        return new IntArrayList();
    }

    public static class InputStrategy implements Object2IntOpenCustomHashMap.Strategy<List<class_1799>> {
        @Override
        public int hashCode(List<class_1799> list) {
            int size = list.size();
            int[] codes = new int[size];
            for (int i = 0; i < size; i++) {
                codes[i] = class_1799.method_57355(list.get(i));
            }
            Arrays.sort(codes);
            int hash = 0;
            for (int i = 0; i < size; i++) {
                hash = hash * 31 + codes[i];

            }
            return hash;
        }

        @Override
        public boolean equals(List<class_1799> a, List<class_1799> b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            int size = a.size();
            if (b.size() != size) {
                return false;
            }
            if (size == 1) {
                return class_1799.method_31577(a.getFirst(), b.getFirst());
            }
            int end = size - 1;
            List<class_1799> queue = new LinkedList<>();
            class_1799 current = b.getFirst();
            int index = 1;
            class_1799 stack;
            for (int i = 0; i < end; i++) {
                stack = a.get(i);
                if (class_1799.method_31577(stack, current)) {
                    current = b.get(index++);
                    continue;
                }
                queue.add(stack);
            }
            stack = a.get(end);
            if (class_1799.method_31577(stack, current)) {
                if (index == size) {
                    return true;
                }
                current = b.get(index++);
            } else {
                if (queue.size() == end) {
                    return false;
                }
                queue.add(stack);
            }
            Iterator<class_1799> iterator;
            Find:
            while (index <= end) {
                iterator = queue.iterator();
                do {
                    stack = iterator.next();
                    if (class_1799.method_31577(stack, current)) {
                        iterator.remove();
                        current = b.get(index++);
                        continue Find;
                    }
                } while (iterator.hasNext());
                return false;
            }
            return class_1799.method_31577(queue.getFirst(), current);
        }
    }
}
