package com.zurrtum.create.client.content.redstone.link;

import com.mojang.datafixers.util.Pair;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBox;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxRenderer;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11659;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_811;

public class LinkRenderer {
    public static void tick(class_310 mc) {
        class_239 target = mc.field_1765;
        if (!(target instanceof class_3965 result))
            return;

        class_638 world = mc.field_1687;
        class_2338 pos = result.method_17777();

        LinkBehaviour behaviour = BlockEntityBehaviour.get(world, pos, LinkBehaviour.TYPE);
        if (behaviour == null)
            return;

        class_2561 freq1 = CreateLang.translateDirect("logistics.firstFrequency");
        class_2561 freq2 = CreateLang.translateDirect("logistics.secondFrequency");

        for (boolean first : Iterate.trueAndFalse) {
            class_238 bb = new class_238(class_243.field_1353, class_243.field_1353).method_1014(.25f);
            class_2561 label = first ? freq1 : freq2;
            boolean hit = behaviour.testHit(first, target.method_17784());
            ValueBoxTransform transform = first ? behaviour.firstSlot : behaviour.secondSlot;

            ValueBox box = new ValueBox(label, bb, pos).passive(!hit);
            boolean empty = behaviour.getNetworkKey().get(first).getStack().method_7960();

            if (!empty)
                box.wideOutline();

            Outliner.getInstance().showOutline(Pair.of(first, pos), box.transform(transform)).highlightFace(result.method_17780());

            if (!hit)
                continue;

            List<class_5250> tip = new ArrayList<>();
            tip.add(label.method_27661());
            tip.add(CreateLang.translateDirect(empty ? "logistics.filter.click_to_set" : "logistics.filter.click_to_replace"));
            Create.VALUE_SETTINGS_HANDLER.showHoverTip(mc, tip);
        }
    }

    @Nullable
    public static LinkRenderState getLinkRenderState(SmartBlockEntity be, class_10442 itemModelManager, double distance) {
        LinkBehaviour behaviour = be.getBehaviour(LinkBehaviour.TYPE);
        if (behaviour == null || behaviour.behaviour == null) {
            return null;
        }
        float max = behaviour.getRenderDistance();
        if (max * max < distance) {
            return null;
        }
        return LinkRenderState.create(
            behaviour.firstSlot,
            behaviour.secondSlot,
            itemModelManager,
            behaviour.getFirstStack(),
            behaviour.getLastStack(),
            be.method_10997()
        );
    }

    public record LinkRenderState(
        ValueBoxTransform firstSlot, class_10444 firstState, float firstOffset, ValueBoxTransform secondSlot, class_10444 secondState,
        float secondOffset
    ) {
        public static LinkRenderState create(
            ValueBoxTransform firstSlot,
            ValueBoxTransform secondSlot,
            class_10442 itemModelManager,
            class_1799 firstStack,
            class_1799 secondStack,
            class_1937 world
        ) {
            class_10444 firstState = new class_10444(), secondState = new class_10444();
            firstState.field_55337 = secondState.field_55337 = class_811.field_4319;
            itemModelManager.method_65596(firstState, firstStack, firstState.field_55337, world, null, 0);
            itemModelManager.method_65596(secondState, secondStack, secondState.field_55337, world, null, 0);
            return new LinkRenderState(
                firstSlot,
                firstState,
                ValueBoxRenderer.customZOffset(firstStack.method_7909()),
                secondSlot,
                secondState,
                ValueBoxRenderer.customZOffset(secondStack.method_7909())
            );
        }

        public void render(class_2680 blockState, class_11659 queue, class_4587 ms, int light) {
            ms.method_22903();
            firstSlot.transform(blockState, ms);
            ValueBoxRenderer.renderItemIntoValueBox(firstState, queue, ms, light, firstOffset);
            ms.method_22909();
            ms.method_22903();
            secondSlot.transform(blockState, ms);
            ValueBoxRenderer.renderItemIntoValueBox(secondState, queue, ms, light, secondOffset);
            ms.method_22909();
        }
    }
}
