package com.zurrtum.create.client.content.redstone.nixieTube;

import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.PonderRenderTypes;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.lib.util.ShadersModHelper;
import com.zurrtum.create.client.foundation.render.RenderTypes;
import com.zurrtum.create.client.foundation.utility.DyeHelper;
import com.zurrtum.create.content.redstone.nixieTube.DoubleFaceAttachedBlock.DoubleAttachFace;
import com.zurrtum.create.content.redstone.nixieTube.NixieTubeBlock;
import com.zurrtum.create.content.redstone.nixieTube.NixieTubeBlockEntity;
import com.zurrtum.create.content.trains.signal.SignalBlockEntity.SignalState;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11767;
import net.minecraft.class_11768;
import net.minecraft.class_11785;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_327.class_6415;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class NixieTubeRenderer implements class_827<NixieTubeBlockEntity, NixieTubeRenderer.NixieTubeRenderState> {
    protected final class_327 textRenderer;

    public NixieTubeRenderer(class_5614.class_5615 context) {
        textRenderer = context.comp_4540();
    }

    @Override
    public NixieTubeRenderState method_74335() {
        return new NixieTubeRenderState();
    }

    @Override
    public void updateRenderState(
        NixieTubeBlockEntity be,
        NixieTubeRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        class_11954.method_74399(be, state, crumblingOverlay);
        if (be.signalState != null || be.computerSignal != null) {
            updateSignalRenderState(be, state, cameraPos);
        } else {
            updateTextRenderState(textRenderer, be, state);
        }
    }

    public static void updateTextRenderState(class_327 textRenderer, NixieTubeBlockEntity be, NixieTubeRenderState state) {
        TextRenderState data = new TextRenderState();
        DoubleAttachFace face = state.field_62674.method_11654(NixieTubeBlock.FACE);
        class_2350 facing = state.field_62674.method_11654(NixieTubeBlock.field_11177);
        data.yRot = class_3532.field_29847 * (AngleHelper.horizontalAngle(facing) - 90 + (face == DoubleAttachFace.WALL_REVERSED ? 180 : 0));
        data.zRot = class_3532.field_29847 * (face == DoubleAttachFace.WALL ? -90 : face == DoubleAttachFace.WALL_REVERSED ? 90 : 0);
        if (face == DoubleAttachFace.CEILING || facing == class_2350.field_11033) {
            data.zRot2 = class_3532.field_29847 * 180;
        }
        data.layer = ShadersModHelper.isShaderPackInUse() ? class_1921.method_29380() : PonderRenderTypes.translucent();
        data.light = state.field_62676;
        data.tube = CachedBuffers.partial(AllPartialModels.NIXIE_TUBE, state.field_62674);
        Couple<String> s = be.getDisplayedStrings();
        if (s != null) {
            class_1767 color = NixieTubeBlock.colorOf(state.field_62674);
            float flicker = be.method_10997().field_9229.method_43057();
            Couple<Integer> couple = DyeHelper.getDyeColors(color);
            int brightColor = couple.getFirst() | 0xFF000000;
            int darkColor = couple.getSecond() | 0xFF000000;
            int flickeringBrightColor = Color.mixColors(brightColor, darkColor, flicker / 4);
            int y = face == DoubleAttachFace.CEILING ? -5 : -3;
            data.left = createTextDrawable(textRenderer, s.getFirst(), y, flickeringBrightColor, darkColor);
            data.right = createTextDrawable(textRenderer, s.getSecond(), y, flickeringBrightColor, darkColor);
        }
        state.data = data;
    }

    @Nullable
    public static TextDrawableState createTextDrawable(class_327 textRenderer, String text, int y, int flickeringBrightColor, int darkColor) {
        int code = visit(text);
        if (code == ' ') {
            return null;
        }
        class_11768 glyph = textRenderer.method_72732(class_2583.field_24360.method_27708()).method_72736(code);
        class_11767 bright = glyph.method_73399(0, 0, flickeringBrightColor, 0, class_2583.field_24360, 0, 0);
        if (bright == null) {
            return null;
        }
        class_11767 dark = glyph.method_73399(0, 0, darkColor, 0, class_2583.field_24360, 0, 0);
        class_11767 mix = glyph.method_73399(0, 0, Color.mixColors(darkColor, 0xFF000000, .35f), 0, class_2583.field_24360, 0, 0);
        float x = (textRenderer.method_1727(text) - .5f) / -2f;
        return new TextDrawableState(bright.method_73401(class_6415.field_33993), x, y, bright, dark, mix);
    }

    public static int visit(String text) {
        int length = text.length();
        if (length == 0) {
            return ' ';
        }
        char c = text.charAt(0);
        if (Character.isHighSurrogate(c)) {
            if (length == 1) {
                return 65533;
            }
            char d = text.charAt(1);
            if (Character.isLowSurrogate(d)) {
                return Character.toCodePoint(c, d);
            }
            return 65533;
        }
        if (Character.isSurrogate(c)) {
            return 65533;
        }
        return c;
    }

    public static void updateSignalRenderState(NixieTubeBlockEntity be, NixieTubeRenderState state, class_243 cameraPos) {
        SignalRenderState data = new SignalRenderState();
        state.data = data;
        DoubleAttachFace face = state.field_62674.method_11654(NixieTubeBlock.FACE);
        class_2350 facing = NixieTubeBlock.getFacing(state.field_62674);
        data.yRot = class_3532.field_29847 * (AngleHelper.horizontalAngle(state.field_62674.method_11654(NixieTubeBlock.field_11177)) - 90 + (face == DoubleAttachFace.WALL_REVERSED ? 180 : 0));
        int zRot = face == DoubleAttachFace.WALL ? -90 : face == DoubleAttachFace.WALL_REVERSED ? 90 : 0;
        if (facing == class_2350.field_11033) {
            zRot += 180;
        }
        data.zRot = class_3532.field_29847 * zRot;
        data.light = state.field_62676;
        data.layer = class_1921.method_23577();
        data.panel = CachedBuffers.partial(AllPartialModels.SIGNAL_PANEL, state.field_62674);
        data.offset = facing == class_2350.field_11033 || state.field_62674.method_11654(NixieTubeBlock.FACE) == DoubleAttachFace.WALL_REVERSED ? 0.25f : -0.25f;

        float renderTime = AnimationTickHolder.getRenderTime(be.method_10997());
        double distance = class_243.method_24953(state.field_62673).method_1020(cameraPos).method_1027();
        boolean vert = facing.method_10166().method_10179();

        if (be.signalState != null) {
            SignalDrawableState left = data.left = new SignalDrawableState();
            SignalState signalState = be.signalState;
            boolean yellow = signalState.isYellowLight(renderTime);
            float longSide = yellow ? 1 : 4;
            float longSideGlow = yellow ? 2 : 5.125f;

            left.light = state.field_62676;
            left.layer = RenderTypes.translucent();
            if (signalState.isRedLight(renderTime)) {
                left.additive = true;
                if (distance < 9216) {
                    left.cubeLayer = left.layer;
                    left.cube = CachedBuffers.partial(AllPartialModels.SIGNAL_WHITE_CUBE, state.field_62674);
                    left.glow = CachedBuffers.partial(AllPartialModels.SIGNAL_RED_GLOW, state.field_62674);
                    if (vert) {
                        left.cubeX = 1;
                        left.cubeY = longSide;
                        left.glowX = 2;
                        left.glowY = longSideGlow;
                    } else {
                        left.cubeX = longSide;
                        left.cubeY = 1;
                        left.glowX = longSideGlow;
                        left.glowY = 2;
                    }
                }
                left.layer = RenderTypes.additive2();
                left.layer2 = RenderTypes.additive();
                left.signal = CachedBuffers.partial(AllPartialModels.SIGNAL_RED, state.field_62674);
            } else {
                left.signal = CachedBuffers.partial(AllPartialModels.NIXIE_TUBE_SINGLE, state.field_62674);
            }
            SignalDrawableState right = data.right = new SignalDrawableState();
            right.light = state.field_62676;
            right.layer = RenderTypes.translucent();
            if (yellow || signalState.isGreenLight(renderTime)) {
                right.additive = true;
                if (distance < 9216) {
                    right.cubeLayer = right.layer;
                    right.cube = CachedBuffers.partial(AllPartialModels.SIGNAL_WHITE_CUBE, state.field_62674);
                    right.glow = CachedBuffers.partial(
                        yellow ? AllPartialModels.SIGNAL_YELLOW_GLOW : AllPartialModels.SIGNAL_WHITE_GLOW,
                        state.field_62674
                    );
                    if (vert) {
                        right.cubeX = longSide;
                        right.cubeY = 1;
                        right.glowX = longSideGlow;
                        right.glowY = 2;
                    } else {
                        right.cubeX = 1;
                        right.cubeY = longSide;
                        right.glowX = 2;
                        right.glowY = longSideGlow;
                    }
                }
                right.layer = RenderTypes.additive2();
                right.layer2 = RenderTypes.additive();
                right.signal = CachedBuffers.partial(yellow ? AllPartialModels.SIGNAL_YELLOW : AllPartialModels.SIGNAL_WHITE, state.field_62674);
            } else {
                right.signal = CachedBuffers.partial(AllPartialModels.NIXIE_TUBE_SINGLE, state.field_62674);
            }
        } else if (be.computerSignal != null) {
            for (boolean first : Iterate.trueAndFalse) {
                NixieTubeBlockEntity.ComputerSignal.TubeDisplay tubeDisplay = first ? be.computerSignal.first : be.computerSignal.second;

                SignalDrawableState cState = new SignalDrawableState();
                if (first)
                    data.left = cState;
                else
                    data.right = cState;

                cState.light = state.field_62676;
                cState.layer = RenderTypes.translucent();
                cState.signal = CachedBuffers.partial(AllPartialModels.NIXIE_TUBE_SINGLE, state.field_62674);

                if (tubeDisplay.blinkPeriod == 0 || tubeDisplay.blinkPeriod > 1 && renderTime % tubeDisplay.blinkPeriod < tubeDisplay.blinkOffTime) {
                    continue;
                }

                cState.signalColor = new Color(tubeDisplay.r, tubeDisplay.g, tubeDisplay.b);

                cState.additive = true;
                if (distance < 9216) {
                    cState.glowColor = new Color(
                        Math.min(((tubeDisplay.r & 0xFF) * 6 + 256) >> 3, 255),
                        Math.min(((tubeDisplay.g & 0xFF) * 6 + 256) >> 3, 255),
                        Math.min(((tubeDisplay.b & 0xFF) * 6 + 256) >> 3, 255)
                    );
                    cState.cubeLayer = RenderTypes.translucent();
                    cState.cube = CachedBuffers.partial(AllPartialModels.SIGNAL_COMPUTER_WHITE_CUBE, state.field_62674);
                    cState.glow = CachedBuffers.partial(AllPartialModels.SIGNAL_COMPUTER_WHITE_GLOW, state.field_62674);

                    float width = vert ? tubeDisplay.glowHeight : tubeDisplay.glowWidth;
                    float height = vert ? tubeDisplay.glowWidth : tubeDisplay.glowHeight;

                    cState.cubeX = width;
                    cState.cubeY = height;
                    cState.glowX = width + 1.125f;
                    cState.glowY = height + 1.125f;
                }
                cState.layer = RenderTypes.additive2();
                cState.layer2 = RenderTypes.additive();
                cState.signal = CachedBuffers.partial(AllPartialModels.SIGNAL_COMPUTER_WHITE, state.field_62674);
            }
        }
    }

    @Override
    public void render(NixieTubeRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        state.data.render(matrices, queue);
    }

    public static void drawInWorldString(class_327 fontRenderer, class_4587 ms, class_4597 buffer, String c, int color) {
        fontRenderer.method_27521(
            c,
            0,
            0,
            color,
            false,
            ms.method_23760().method_23761(),
            buffer,
            class_6415.field_33993,
            0,
            class_765.field_32767
        );
    }

    @Override
    public int method_33893() {
        return 128;
    }

    public static class NixieTubeRenderState extends class_11954 {
        public NixieTubeRenderData data;
    }

    public interface NixieTubeRenderData {
        void render(class_4587 matrices, class_11659 queue);
    }

    public static class TextRenderState implements NixieTubeRenderData, class_11659.class_11660 {
        public class_1921 layer;
        public float yRot;
        public float zRot;
        public float zRot2;
        public TextDrawableState left;
        public TextDrawableState right;
        public SuperByteBuffer tube;
        public int light;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            tube.light(light).renderInto(matricesEntry, vertexConsumer);
        }

        @Override
        public void render(class_4587 matrices, class_11659 queue) {
            matrices.method_22903();
            matrices.method_46416(0.5f, 0.5f, 0.5f);
            matrices.method_22907(class_7833.field_40716.rotation(yRot));
            matrices.method_22907(class_7833.field_40718.rotation(zRot));
            class_11785 batchingQueue = ShadersModHelper.isShaderPackInUse() ? queue.method_73529(1) : queue;
            if (zRot2 != 0) {
                matrices.method_22903();
                matrices.method_22907(class_7833.field_40718.rotation(zRot2));
                batchingQueue.method_73483(matrices, layer, this);
                matrices.method_22909();
            } else {
                batchingQueue.method_73483(matrices, layer, this);
            }
            if (left != null) {
                matrices.method_22903();
                matrices.method_46416(-0.25f, 0, 0);
                matrices.method_22905(0.05f, -0.05f, 0.05f);
                queue.method_73483(matrices, left.layer, left);
                matrices.method_22909();
            }
            if (right != null) {
                matrices.method_46416(0.25f, 0, 0);
                matrices.method_22905(0.05f, -0.05f, 0.05f);
                queue.method_73483(matrices, right.layer, right);
            }
            matrices.method_22909();
        }
    }

    public record TextDrawableState(
        class_1921 layer, float x, int y, class_11767 bright, class_11767 dark, class_11767 mix
    ) implements class_11659.class_11660 {
        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            Matrix4f pose = matricesEntry.method_23761();
            pose.translate(x, y, 0);
            bright.method_73403(pose, vertexConsumer, class_765.field_32767, false);
            pose.translate(0.5f, 0.5f, -0.0625f);
            dark.method_73403(pose, vertexConsumer, class_765.field_32767, false);
            pose.scale(-1, 1, 1);
            pose.translate(0.5f + x + x, -0.5f, 0.0625f);
            dark.method_73403(pose, vertexConsumer, class_765.field_32767, false);
            pose.translate(-0.5f, 0.5f, -0.0625f);
            mix.method_73403(pose, vertexConsumer, class_765.field_32767, false);
        }
    }

    public static class SignalRenderState implements NixieTubeRenderData, class_11659.class_11660 {
        public float yRot;
        public float zRot;
        public int light;
        public class_1921 layer;
        public SuperByteBuffer panel;
        public float offset;
        public SignalDrawableState left;
        public SignalDrawableState right;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            panel.light(light).renderInto(matricesEntry, vertexConsumer);
        }

        @Override
        public void render(class_4587 matrices, class_11659 queue) {
            matrices.method_22903();
            matrices.method_46416(0.5f, 0.5f, 0.5f);
            matrices.method_22907(class_7833.field_40716.rotation(yRot));
            matrices.method_22907(class_7833.field_40718.rotation(zRot));
            matrices.method_46416(-0.5f, -0.5f, -0.5f);
            queue.method_73483(matrices, layer, this);
            matrices.method_46416(0.5f, 0.46875f, 0.5f);
            matrices.method_22903();
            matrices.method_46416(offset, 0, 0);
            left.render(matrices, queue);
            matrices.method_22909();
            matrices.method_46416(-offset, 0, 0);
            right.render(matrices, queue);
            matrices.method_22909();
        }
    }

    public static class SignalDrawableState {
        public class_1921 layer;
        public class_1921 layer2;
        public SuperByteBuffer signal;
        public int light;
        public class_1921 cubeLayer;
        public SuperByteBuffer cube;
        public float cubeX;
        public float cubeY;
        public SuperByteBuffer glow;
        public float glowX;
        public float glowY;
        public Color signalColor;
        public Color glowColor;
        public boolean additive;

        public void render(class_4587 matrices, class_11659 queue) {
            if (ShadersModHelper.isShaderPackInUse()) {
                if (additive) {
                    queue.method_73529(1).method_73483(matrices, layer, (e, v) -> renderAdditive(e, v, 153));
                    if (cube != null) {
                        queue.method_73529(1).method_73483(matrices, cubeLayer, this::renderCube);
                    }
                    queue.method_73529(2).method_73483(matrices, layer2, (e, v) -> renderAdditive(e, v, 102));
                } else {
                    queue.method_73529(1).method_73483(matrices, layer, this::renderNormal);
                }
            } else {
                if (additive) {
                    queue.method_73483(matrices, layer, (e, v) -> renderAdditive(e, v, 153));
                    if (cube != null) {
                        queue.method_73483(matrices, cubeLayer, this::renderCube);
                    }
                    queue.method_73483(matrices, layer2, (e, v) -> renderAdditive(e, v, 102));
                } else {
                    queue.method_73483(matrices, layer, this::renderNormal);
                }
            }
        }

        public void renderCube(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            cube.light(class_765.field_32767).disableDiffuse().scale(cubeX, cubeY, 1).renderInto(matricesEntry, vertexConsumer);
        }

        public void renderAdditive(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer, int color) {
            if (glow != null) {
                var gBuff = glow.light(class_765.field_32767).disableDiffuse().scale(glowX, glowY, 2);
                if (glowColor != null) {
                    gBuff.color(glowColor);
                } else {
                    gBuff.color(color, color, color, color);
                }
                gBuff.renderInto(matricesEntry, vertexConsumer);
            }
            var sBuff = signal.light(class_765.field_32767).disableDiffuse().scale(1.0625f);
            if (signalColor != null) {
                sBuff.color(signalColor);
            } else {
                sBuff.color(color, color, color, color);
            }
            sBuff.renderInto(matricesEntry, vertexConsumer);
        }

        public void renderNormal(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            signal.light(light).renderInto(matricesEntry, vertexConsumer);
        }
    }
}
