package com.zurrtum.create.client.content.schematics.client;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.levelWrappers.SchematicLevel;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.outliner.AABBOutline;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import com.zurrtum.create.client.content.schematics.client.tools.ToolType;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.contraptions.StructureTransform;
import com.zurrtum.create.content.schematics.SchematicInstances;
import com.zurrtum.create.content.schematics.SchematicItem;
import com.zurrtum.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.infrastructure.packet.c2s.SchematicPlacePacket;
import com.zurrtum.create.infrastructure.packet.c2s.SchematicSyncPacket;
import java.util.List;
import net.minecraft.class_11908;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_9779;

public class SchematicHandler {

    private String displayedSchematic;
    private SchematicTransformation transformation;
    private class_238 bounds;
    private boolean deployed;
    private boolean active;
    private ToolType currentTool;

    private static final int SYNC_DELAY = 10;
    private int syncCooldown;
    private int activeHotbarSlot;
    private class_1799 activeSchematicItem;
    private AABBOutline outline;

    private final SchematicRenderer[] renderers = new SchematicRenderer[3];
    private final SchematicHotbarSlotOverlay overlay;
    private ToolSelectionScreen selectionScreen;

    public SchematicHandler() {
        overlay = new SchematicHotbarSlotOverlay();
        currentTool = ToolType.DEPLOY;
        selectionScreen = new ToolSelectionScreen(class_310.method_1551(), ImmutableList.of(ToolType.DEPLOY), this::equip);
        transformation = new SchematicTransformation();
    }

    public void tick(class_310 mc) {
        if (mc.field_1761.method_2920() == class_1934.field_9219) {
            if (active) {
                active = false;
                syncCooldown = 0;
                activeHotbarSlot = 0;
                activeSchematicItem = null;
            }
            return;
        }

        if (activeSchematicItem != null && transformation != null)
            transformation.tick();

        class_746 player = mc.field_1724;
        class_1799 stack = findBlueprintInHand(player);
        if (stack == null) {
            active = false;
            syncCooldown = 0;
            if (activeSchematicItem != null && itemLost(player)) {
                activeHotbarSlot = 0;
                activeSchematicItem = null;
            }
            return;
        }

        if (!active || !stack.method_58694(AllDataComponents.SCHEMATIC_FILE).equals(displayedSchematic)) {
            init(mc, stack);
        }
        if (!active)
            return;

        if (syncCooldown > 0)
            syncCooldown--;
        if (syncCooldown == 1)
            sync(player);

        selectionScreen.update();
        currentTool.getTool().updateSelection(mc);
    }

    private void init(class_310 mc, class_1799 stack) {
        class_746 player = mc.field_1724;
        loadSettings(stack);
        displayedSchematic = stack.method_58694(AllDataComponents.SCHEMATIC_FILE);
        active = true;
        if (deployed) {
            setupRenderer(mc);
            ToolType toolBefore = currentTool;
            selectionScreen = new ToolSelectionScreen(mc, ToolType.getTools(player.method_68878()), this::equip);
            if (toolBefore != null) {
                selectionScreen.setSelectedElement(toolBefore);
                equip(toolBefore);
            }
        } else
            selectionScreen = new ToolSelectionScreen(mc, ImmutableList.of(ToolType.DEPLOY), this::equip);
    }

    private void setupRenderer(class_310 mc) {
        class_1937 clientWorld = mc.field_1687;
        class_3499 schematic = SchematicItem.loadSchematic(clientWorld, activeSchematicItem);
        class_2382 size = schematic.method_15160();
        if (size.equals(class_2382.field_11176))
            return;

        SchematicLevel w = new SchematicLevel(clientWorld);
        SchematicLevel wMirroredFB = new SchematicLevel(clientWorld);
        SchematicLevel wMirroredLR = new SchematicLevel(clientWorld);
        class_3492 placementSettings = new class_3492();
        StructureTransform transform;
        class_2338 pos;

        pos = class_2338.field_10980;

        try {
            schematic.method_15172(w, pos, pos, placementSettings, w.method_8409(), class_2248.field_31028);
            for (class_2586 blockEntity : w.getBlockEntities())
                blockEntity.method_31662(w);
            fixControllerBlockEntities(w);
        } catch (Exception e) {
            mc.field_1724.method_7353(CreateLang.translate("schematic.error").component(), false);
            Create.LOGGER.error("Failed to load Schematic for Previewing", e);
            return;
        }

        placementSettings.method_15125(class_2415.field_11301);
        pos = class_2338.field_10980.method_10089(size.method_10263() - 1);
        schematic.method_15172(wMirroredFB, pos, pos, placementSettings, wMirroredFB.method_8409(), class_2248.field_31028);
        transform = new StructureTransform(placementSettings.method_15134(), class_2351.field_11052, class_2470.field_11467, placementSettings.method_15114());
        for (class_2586 be : wMirroredFB.getRenderedBlockEntities())
            transform.apply(be);
        fixControllerBlockEntities(wMirroredFB);

        placementSettings.method_15125(class_2415.field_11300);
        pos = class_2338.field_10980.method_10077(size.method_10260() - 1);
        schematic.method_15172(wMirroredLR, pos, pos, placementSettings, wMirroredFB.method_8409(), class_2248.field_31028);
        transform = new StructureTransform(placementSettings.method_15134(), class_2351.field_11052, class_2470.field_11467, placementSettings.method_15114());
        for (class_2586 be : wMirroredLR.getRenderedBlockEntities())
            transform.apply(be);
        fixControllerBlockEntities(wMirroredLR);

        renderers[0] = new SchematicRenderer(w);
        renderers[1] = new SchematicRenderer(wMirroredFB);
        renderers[2] = new SchematicRenderer(wMirroredLR);
    }

    private void fixControllerBlockEntities(SchematicLevel level) {
        for (class_2586 blockEntity : level.getBlockEntities()) {
            if (!(blockEntity instanceof IMultiBlockEntityContainer multiBlockEntity))
                continue;
            class_2338 lastKnown = multiBlockEntity.getLastKnownPos();
            class_2338 current = blockEntity.method_11016();
            if (lastKnown == null || current == null)
                continue;
            if (multiBlockEntity.isController())
                continue;
            if (!lastKnown.equals(current)) {
                class_2338 newControllerPos = multiBlockEntity.getController().method_10081(current.method_10059(lastKnown));
                if (multiBlockEntity instanceof SmartBlockEntity sbe)
                    sbe.markVirtual();
                multiBlockEntity.setController(newControllerPos);
            }
        }
    }

    public void render(class_310 mc, class_4587 ms, SuperRenderTypeBuffer buffer, class_243 camera) {
        if (!active) {
            return;
        }
        boolean present = activeSchematicItem != null;
        if (!present) {
            return;
        }

        ms.method_22903();
        currentTool.getTool().renderTool(mc, ms, buffer, camera);
        ms.method_22909();

        ms.method_22903();
        transformation.applyTransformations(ms, camera);

        if (deployed) {
            float pt = AnimationTickHolder.getPartialTicks();
            boolean lr = transformation.getScaleLR().getValue(pt) < 0;
            boolean fb = transformation.getScaleFB().getValue(pt) < 0;
            if (lr && !fb && renderers[2] != null) {
                renderers[2].render(mc, ms, buffer, transformation, camera);
            } else if (fb && !lr && renderers[1] != null) {
                renderers[1].render(mc, ms, buffer, transformation, camera);
            } else if (renderers[0] != null) {
                renderers[0].render(mc, ms, buffer, transformation, camera);
            }
        }

        currentTool.getTool().renderOnSchematic(mc, ms, buffer);

        ms.method_22909();
    }

    public void updateRenderers() {
        for (SchematicRenderer renderer : renderers) {
            if (renderer != null) {
                renderer.update();
            }
        }
    }

    public void render(class_310 mc, class_332 guiGraphics, class_9779 deltaTracker) {
        if (!active)
            return;
        float tickProgress = deltaTracker.method_60637(false);
        if (activeSchematicItem != null)
            overlay.renderOn(mc, guiGraphics, activeHotbarSlot, tickProgress);
        currentTool.getTool()
            .renderOverlay(mc.field_1705, guiGraphics, tickProgress, guiGraphics.method_51421(), guiGraphics.method_51443());
        selectionScreen.renderPassive(guiGraphics, tickProgress);
    }

    public boolean onMouseInput(class_310 mc, int button) {
        if (!active)
            return false;
        if (button != 1)
            return false;
        if (mc.field_1724.method_5715())
            return false;
        if (mc.field_1765 instanceof class_3965 blockRayTraceResult) {
            class_2680 clickedBlock = mc.field_1687.method_8320(blockRayTraceResult.method_17777());
            if (clickedBlock.method_27852(AllBlocks.SCHEMATICANNON))
                return false;
            if (clickedBlock.method_27852(AllBlocks.DEPLOYER))
                return false;
        }
        return currentTool.getTool().handleRightClick(mc);
    }

    public boolean onKeyInput(class_11908 input, boolean pressed) {
        if (!active || !AllKeys.TOOL_MENU.method_1417(input))
            return false;

        if (pressed && !selectionScreen.focused)
            selectionScreen.focused = true;
        if (!pressed && selectionScreen.focused) {
            selectionScreen.focused = false;
            selectionScreen.method_25419();
        }
        return true;
    }

    public boolean mouseScrolled(double delta) {
        if (!active)
            return false;

        if (selectionScreen.focused) {
            selectionScreen.cycle((int) Math.signum(delta));
            return true;
        }
        if (AllKeys.hasControlDown())
            return currentTool.getTool().handleMouseWheel(delta);
        return false;
    }

    private class_1799 findBlueprintInHand(class_1657 player) {
        class_1799 stack = player.method_6047();
        if (!stack.method_31574(AllItems.SCHEMATIC))
            return null;
        if (!stack.method_57826(AllDataComponents.SCHEMATIC_FILE))
            return null;

        activeSchematicItem = stack;
        activeHotbarSlot = player.method_31548().method_67532();
        return stack;
    }

    private boolean itemLost(class_1657 player) {
        class_1661 inventory = player.method_31548();
        for (int i = 0, size = class_1661.method_7368(); i < size; i++) {
            if (inventory.method_5438(i).method_31574(activeSchematicItem.method_7909()))
                continue;
            if (!class_1799.method_7973(inventory.method_5438(i), activeSchematicItem))
                continue;
            return false;
        }
        return true;
    }

    public void markDirty() {
        syncCooldown = SYNC_DELAY;
    }

    public void sync(class_746 player) {
        if (activeSchematicItem == null)
            return;
        player.field_3944.method_52787(new SchematicSyncPacket(
            activeHotbarSlot,
            transformation.toSettings(),
            transformation.getAnchor(),
            deployed
        ));
    }

    public void equip(ToolType tool) {
        this.currentTool = tool;
        currentTool.getTool().init();
    }

    public void loadSettings(class_1799 blueprint) {
        class_2338 anchor = class_2338.field_10980;
        class_3492 settings = SchematicItem.getSettings(blueprint);
        transformation = new SchematicTransformation();

        deployed = blueprint.method_58695(AllDataComponents.SCHEMATIC_DEPLOYED, false);
        anchor = blueprint.method_58695(AllDataComponents.SCHEMATIC_ANCHOR, class_2338.field_10980);
        class_2382 size = blueprint.method_58694(AllDataComponents.SCHEMATIC_BOUNDS);
        if (size == null) {
            return;
        }

        bounds = new class_238(0, 0, 0, size.method_10263(), size.method_10264(), size.method_10260());
        outline = new AABBOutline(bounds);
        outline.getParams().colored(0x6886c5).lineWidth(1 / 16f);
        transformation.init(anchor, settings, bounds);
    }

    public void deploy(class_310 mc) {
        if (!deployed) {
            List<ToolType> tools = ToolType.getTools(mc.field_1724.method_68878());
            selectionScreen = new ToolSelectionScreen(mc, tools, this::equip);
        }
        deployed = true;
        setupRenderer(mc);
    }

    public String getCurrentSchematicName() {
        return displayedSchematic != null ? displayedSchematic : "-";
    }

    public void printInstantly(class_310 mc) {
        mc.field_1724.field_3944.method_52787(new SchematicPlacePacket(activeSchematicItem.method_7972()));
        activeSchematicItem.method_57379(AllDataComponents.SCHEMATIC_DEPLOYED, false);
        SchematicInstances.clearHash(activeSchematicItem);
        active = false;
        markDirty();
    }

    public boolean isActive() {
        return active;
    }

    public class_238 getBounds() {
        return bounds;
    }

    public SchematicTransformation getTransformation() {
        return transformation;
    }

    public boolean isDeployed() {
        return deployed;
    }

    public class_1799 getActiveSchematicItem() {
        return activeSchematicItem;
    }

    public AABBOutline getOutline() {
        return outline;
    }

}
