package com.zurrtum.create.client.content.trains.entity;

import com.zurrtum.create.client.content.contraptions.render.ClientContraption;
import com.zurrtum.create.content.trains.bogey.AbstractBogeyBlock;
import com.zurrtum.create.content.trains.entity.CarriageContraption;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3499.class_3501;

public class CarriageClientContraption extends ClientContraption {
    // Parallel array to renderedBlockEntityView. Marks BEs that are outside the portal.
    public final BitSet scratchBlockEntitiesOutsidePortal = new BitSet();

    public CarriageClientContraption(CarriageContraption contraption) {
        super(contraption);
    }

    @Override
    public RenderedBlocks getRenderedBlocks() {
        CarriageContraption contraption = (CarriageContraption) this.contraption;
        if (contraption.notInPortal())
            return super.getRenderedBlocks();

        Map<class_2338, class_2680> values = new HashMap<>();
        contraption.getBlocks().forEach((pos, info) -> {
            if (contraption.withinVisible(pos)) {
                values.put(pos, info.comp_1342());
            } else if (contraption.atSeam(pos)) {
                values.put(pos, class_2246.field_10399.method_9564());
            }
        });
        return new RenderedBlocks(pos -> values.getOrDefault(pos, class_2246.field_10124.method_9564()), values.keySet());
    }

    @Override
    public class_2586 readBlockEntity(class_1937 level, class_3501 info, boolean legacy) {
        if (info.comp_1342().method_26204() instanceof AbstractBogeyBlock<?> bogey && !bogey.captureBlockEntityForTrain())
            return null; // Bogeys are typically rendered by the carriage contraption, not the BE

        return super.readBlockEntity(level, info, legacy);
    }

    @Override
    public BitSet getAndAdjustShouldRenderBlockEntities() {
        CarriageContraption contraption = (CarriageContraption) this.contraption;
        if (contraption.notInPortal()) {
            return super.getAndAdjustShouldRenderBlockEntities();
        }

        scratchBlockEntitiesOutsidePortal.clear();
        scratchBlockEntitiesOutsidePortal.or(shouldRenderBlockEntities);

        for (var i = 0; i < renderedBlockEntityView.size(); i++) {
            var be = renderedBlockEntityView.get(i);
            if (contraption.isHiddenInPortal(be.method_11016())) {
                scratchBlockEntitiesOutsidePortal.clear(i);
            }
        }

        return scratchBlockEntitiesOutsidePortal;
    }
}
