package com.zurrtum.create.client.content.trains.observer;

import com.zurrtum.create.client.AllTrackRenders;
import com.zurrtum.create.client.content.trains.track.TrackBlockRenderState;
import com.zurrtum.create.client.content.trains.track.TrackBlockRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.content.trains.observer.TrackObserver;
import com.zurrtum.create.content.trains.observer.TrackObserverBlockEntity;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour.RenderedTrackOverlayType;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_12075;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_5614;
import org.jetbrains.annotations.Nullable;

public class TrackObserverRenderer extends SmartBlockEntityRenderer<TrackObserverBlockEntity, TrackObserverRenderer.TrackObserverRenderState> {
    public TrackObserverRenderer(class_5614.class_5615 context) {
        super(context);
    }

    @Override
    public TrackObserverRenderState createRenderState() {
        return new TrackObserverRenderState();
    }

    @Override
    public void updateRenderState(
        TrackObserverBlockEntity be,
        TrackObserverRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        super.updateRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        class_1937 world = be.method_10997();
        if (VisualizationManager.supportsVisualization(world)) {
            return;
        }
        TrackTargetingBehaviour<TrackObserver> target = be.edgePoint;
        class_2338 targetPosition = target.getGlobalPosition();
        class_2680 trackState = world.method_8320(targetPosition);
        class_2248 block = trackState.method_26204();
        if (!(block instanceof ITrackBlock track)) {
            return;
        }
        TrackBlockRenderer renderer = AllTrackRenders.get(track);
        if (renderer != null) {
            state.block = renderer.getRenderState(
                world,
                new class_243(targetPosition.method_10263() - state.pos.getX(),
                    targetPosition.method_10264() - state.pos.getY(),
                    targetPosition.method_10260() - state.pos.getZ()
                ),
                trackState,
                targetPosition,
                target.getTargetDirection(),
                target.getTargetBezier(),
                RenderedTrackOverlayType.OBSERVER,
                1
            );
        }
    }

    @Override
    public void render(TrackObserverRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        super.render(state, matrices, queue, cameraState);
        if (state.block != null) {
            state.block.render(matrices, queue);
        }
    }

    public static class TrackObserverRenderState extends SmartRenderState {
        public TrackBlockRenderState block;
    }
}
