package com.zurrtum.create.client.content.trains.schedule.condition;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.client.content.trains.schedule.IScheduleInput;
import com.zurrtum.create.client.foundation.gui.ModularGuiLineBuilder;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.redstone.link.RedstoneLinkNetworkHandler.Frequency;
import com.zurrtum.create.content.trains.schedule.condition.RedstoneLinkCondition;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public class RedstoneLinkConditionRender implements IScheduleInput<RedstoneLinkCondition> {
    @Override
    public int slotsTargeted() {
        return 2;
    }

    @Override
    public Pair<class_1799, class_2561> getSummary(RedstoneLinkCondition input) {
        return Pair.of(
            AllItems.REDSTONE_LINK.method_7854(),
            input.lowActivation() ? CreateLang.translateDirect("schedule.condition.redstone_link_off") : CreateLang.translateDirect(
                "schedule.condition.redstone_link_on")
        );
    }

    @Override
    public List<class_2561> getSecondLineTooltip(int slot) {
        return ImmutableList.of(CreateLang.translateDirect(slot == 0 ? "logistics.firstFrequency" : "logistics.secondFrequency")
            .method_27692(class_124.field_1061));
    }

    @Override
    public List<class_2561> getTitleAs(RedstoneLinkCondition input, String type) {
        return ImmutableList.of(
            CreateLang.translateDirect("schedule.condition.redstone_link.frequency_" + (input.lowActivation() ? "unpowered" : "powered")),
            class_2561.method_43470(" #1 ").method_27692(class_124.field_1080).method_10852(input.freq.getFirst().getStack().method_7964().method_27661().method_27692(class_124.field_1062)),
            class_2561.method_43470(" #2 ").method_27692(class_124.field_1080).method_10852(input.freq.getSecond().getStack().method_7964().method_27661().method_27692(class_124.field_1062))
        );
    }

    @Override
    public void setItem(RedstoneLinkCondition input, int slot, class_1799 stack) {
        input.freq.set(slot == 0, Frequency.of(stack));
    }

    @Override
    public class_1799 getItem(RedstoneLinkCondition input, int slot) {
        return input.freq.get(slot == 0).getStack();
    }

    @Override
    public void initConfigurationWidgets(RedstoneLinkCondition input, ModularGuiLineBuilder builder) {
        builder.addSelectionScrollInput(
            20,
            101,
            (i, l) -> i.forOptions(CreateLang.translatedOptions("schedule.condition.redstone_link", "powered", "unpowered"))
                .titled(CreateLang.translateDirect("schedule.condition.redstone_link.frequency_state")),
            "Inverted"
        );
    }
}
