package com.zurrtum.create.client.content.trains.signal;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllTrackRenders;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.trains.track.TrackBlockRenderState;
import com.zurrtum.create.client.content.trains.track.TrackBlockRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.content.trains.signal.SignalBlockEntity;
import com.zurrtum.create.content.trains.signal.SignalBlockEntity.OverlayState;
import com.zurrtum.create.content.trains.signal.SignalBoundary;
import com.zurrtum.create.content.trains.track.ITrackBlock;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour;
import com.zurrtum.create.content.trains.track.TrackTargetingBehaviour.RenderedTrackOverlayType;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

public class SignalRenderer implements class_827<SignalBlockEntity, SignalRenderer.SignalRenderState> {
    public SignalRenderer(class_5614.class_5615 context) {
    }

    @Override
    public SignalRenderState method_74335() {
        return new SignalRenderState();
    }

    @Override
    public void updateRenderState(
        SignalBlockEntity be,
        SignalRenderState state,
        float tickProgress,
        class_243 cameraPos,
        @Nullable class_11683.class_11792 crumblingOverlay
    ) {
        class_1937 world = be.method_10997();
        if (VisualizationManager.supportsVisualization(world)) {
            return;
        }
        state.field_62673 = be.method_11016();
        state.field_62674 = be.method_11010();
        state.field_62675 = be.method_11017();
        state.layer = class_1921.method_23577();
        float renderTime = AnimationTickHolder.getRenderTime(world);
        if (be.getState().isRedLight(renderTime)) {
            state.model = CachedBuffers.partial(AllPartialModels.SIGNAL_ON, state.field_62674);
            state.field_62676 = class_765.field_32769;
        } else {
            state.model = CachedBuffers.partial(AllPartialModels.SIGNAL_OFF, state.field_62674);
            state.field_62676 = world != null ? class_761.method_23794(
                world,
                state.field_62673
            ) : class_765.field_32767;
        }
        TrackTargetingBehaviour<SignalBoundary> target = be.edgePoint;
        class_2338 targetPosition = target.getGlobalPosition();
        class_2680 trackState = world.method_8320(targetPosition);
        class_2248 block = trackState.method_26204();
        if (!(block instanceof ITrackBlock trackBlock)) {
            return;
        }
        OverlayState overlayState = be.getOverlay();
        if (overlayState == OverlayState.SKIP) {
            return;
        }
        TrackBlockRenderer renderer = AllTrackRenders.get(trackBlock);
        if (renderer != null) {
            RenderedTrackOverlayType type = overlayState == OverlayState.DUAL ? RenderedTrackOverlayType.DUAL_SIGNAL : RenderedTrackOverlayType.SIGNAL;
            state.block = renderer.getRenderState(
                world,
                new class_243(
                    targetPosition.method_10263() - state.field_62673.method_10263(),
                    targetPosition.method_10264() - state.field_62673.method_10264(),
                    targetPosition.method_10260() - state.field_62673.method_10260()
                ),
                trackState,
                targetPosition,
                target.getTargetDirection(),
                target.getTargetBezier(),
                type,
                1
            );
        }
    }

    @Override
    public void render(SignalRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        queue.method_73483(matrices, state.layer, state);
        if (state.block != null) {
            state.block.render(matrices, queue);
        }
    }

    public static class SignalRenderState extends class_11954 implements class_11659.class_11660 {
        public class_1921 layer;
        public SuperByteBuffer model;
        TrackBlockRenderState block;

        @Override
        public void render(class_4587.class_4665 matricesEntry, class_4588 vertexConsumer) {
            model.light(field_62676).renderInto(matricesEntry, vertexConsumer);
        }
    }
}
