package com.zurrtum.create.client.flywheel.impl.visualization;

import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_310;

public final class VisualizationEventHandler {
    private VisualizationEventHandler() {
    }

    public static void onClientTick(class_310 minecraft, class_1937 level) {
        // The game won't be paused in the tick event, but let's make sure there's a player.
        if (minecraft.field_1724 == null) {
            return;
        }

        VisualizationManagerImpl manager = VisualizationManagerImpl.get(level);
        if (manager == null) {
            return;
        }

        manager.tick();
    }

    public static void onEntityJoinLevel(class_1937 level, class_1297 entity) {
        VisualizationManager manager = VisualizationManager.get(level);
        if (manager == null) {
            return;
        }

        manager.entities().queueAdd(entity);
    }

    public static void onEntityLeaveLevel(class_1937 level, class_1297 entity) {
        VisualizationManager manager = VisualizationManager.get(level);
        if (manager == null) {
            return;
        }

        manager.entities().queueRemove(entity);
    }
}
