package com.zurrtum.create.client.flywheel.lib.visual;

import com.zurrtum.create.client.flywheel.api.instance.InstancerProvider;
import com.zurrtum.create.client.flywheel.api.visual.Visual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import net.minecraft.class_1937;
import net.minecraft.class_2382;

public abstract class AbstractVisual implements Visual {
    /**
     * The visualization context used to construct this visual.
     * <br>
     * Useful for passing to child visuals.
     */
    protected final VisualizationContext visualizationContext;
    protected final class_1937 level;

    protected boolean deleted = false;

    public AbstractVisual(VisualizationContext ctx, class_1937 level, float partialTick) {
        this.visualizationContext = ctx;
        this.level = level;
    }

    @Override
    public void update(float partialTick) {
    }

    protected abstract void _delete();

    protected InstancerProvider instancerProvider() {
        return visualizationContext.instancerProvider();
    }

    protected class_2382 renderOrigin() {
        return visualizationContext.renderOrigin();
    }

    @Override
    public final void delete() {
        if (deleted) {
            return;
        }

        _delete();
        deleted = true;
    }
}
