package com.zurrtum.create.client.foundation.block.connected;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;

public class CTSpriteShifter {

    private static final Map<String, CTSpriteShiftEntry> ENTRY_CACHE = new HashMap<>();

    public static CTSpriteShiftEntry getCT(CTType type, class_2960 blockTexture, class_2960 connectedTexture) {
        String key = blockTexture + "->" + connectedTexture + "+" + type.getId();
        if (ENTRY_CACHE.containsKey(key))
            return ENTRY_CACHE.get(key);

        CTSpriteShiftEntry entry = new CTSpriteShiftEntry(type);
        entry.set(blockTexture, connectedTexture);
        ENTRY_CACHE.put(key, entry);
        return entry;
    }

}
