package com.zurrtum.create.client.foundation.blockEntity.behaviour;

import com.zurrtum.create.client.catnip.outliner.ChasingAABBOutline;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform.Sided;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.content.logistics.filter.FilterItem;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_765;
import net.minecraft.class_811;

public class ValueBox extends ChasingAABBOutline {
    protected class_2561 label;

    public int overrideColor = -1;
    public boolean isPassive;

    protected ValueBoxTransform transform;

    protected class_2338 pos;
    protected class_2680 blockState;
    protected class_10444 state;

    protected AllIcons outline = AllIcons.VALUE_BOX_HOVER_4PX;

    public ValueBox(class_2561 label, class_238 bb, class_2338 pos) {
        this(label, bb, pos, class_310.method_1551().field_1687.method_8320(pos));
    }

    public ValueBox(class_2561 label, class_238 bb, class_2338 pos, class_2680 state) {
        super(bb);
        this.label = label;
        this.pos = pos;
        this.blockState = state;
        this.state = new class_10444();
    }

    public ValueBox transform(ValueBoxTransform transform) {
        this.transform = transform;
        return this;
    }

    public ValueBox wideOutline() {
        this.outline = AllIcons.VALUE_BOX_HOVER_6PX;
        return this;
    }

    public ValueBox passive(boolean passive) {
        this.isPassive = passive;
        return this;
    }

    public ValueBox withColor(int color) {
        this.overrideColor = color;
        return this;
    }

    @Override
    public void render(class_310 mc, class_4587 ms, SuperRenderTypeBuffer buffer, class_243 camera, float pt) {
        boolean hasTransform = transform != null;
        if (transform instanceof Sided && params.getHighlightedFace() != null)
            ((Sided) transform).fromSide(params.getHighlightedFace());

        if (hasTransform && !transform.shouldRender(blockState))
            return;

        ms.method_22903();
        ms.method_22904(pos.method_10263() - camera.field_1352, pos.method_10264() - camera.field_1351, pos.method_10260() - camera.field_1350);
        if (hasTransform)
            transform.transform(blockState, ms);

        if (!isPassive) {
            ms.method_22903();
            ms.method_22905(-2.01f, -2.01f, 2.01f);
            ms.method_22904(-8 / 16.0, -8 / 16.0, -.5 / 16.0);
            getOutline().render(ms, buffer, 0xffffff);
            ms.method_22909();
        }

        float fontScale = hasTransform ? -transform.getFontScale() : -1 / 64f;
        ms.method_22905(fontScale, fontScale, fontScale);
        renderContents(mc, ms, buffer);

        ms.method_22909();
    }

    public AllIcons getOutline() {
        return outline;
    }

    public void renderContents(class_310 mc, class_4587 ms, class_4597 buffer) {
    }

    public static class ItemValueBox extends ValueBox {
        class_1799 stack;
        class_5250 count;

        public ItemValueBox(class_2561 label, class_238 bb, class_2338 pos, class_1799 stack, class_5250 count) {
            super(label, bb, pos);
            this.stack = stack;
            this.count = count;
        }

        @Override
        public AllIcons getOutline() {
            if (!stack.method_7960())
                return AllIcons.VALUE_BOX_HOVER_6PX;
            return super.getOutline();
        }

        @Override
        public void renderContents(class_310 mc, class_4587 ms, class_4597 buffer) {
            if (count == null)
                return;

            class_327 font = mc.field_1772;
            ms.method_22904(17.5, -5, 7);

            boolean isFilter = stack.method_7909() instanceof FilterItem;
            boolean isEmpty = stack.method_7960();

            class_10442 itemModelManager = mc.method_65386();
            itemModelManager.method_65598(state, stack, class_811.field_4317, mc.field_1687, mc.field_1724, 0);
            boolean blockItem = state.method_65608();

            float scale = 1.5f;
            ms.method_46416(-font.method_27525(count), 0, 0);

            if (isFilter) {
                ms.method_46416(-5, 8, 0);
            } else if (isEmpty) {
                ms.method_22904(-15, -1, -2.75);
                scale = 1.65f;
            } else {
                ms.method_46416(-7, 10, blockItem ? 10 + 1 / 4f : 0);
            }

            if (count.getString().equals("*"))
                ms.method_46416(-1, 3, 0);

            ms.method_22905(scale, scale, scale);
            drawString8x(ms, buffer, count, 0, 0, isFilter ? 0xFFFFFFFF : 0xFFEDEDED);
        }

    }

    public static class TextValueBox extends ValueBox {
        class_2561 text;

        public TextValueBox(class_2561 label, class_238 bb, class_2338 pos, class_2561 text) {
            super(label, bb, pos);
            this.text = text;
        }

        public TextValueBox(class_2561 label, class_238 bb, class_2338 pos, class_2680 state, class_2561 text) {
            super(label, bb, pos, state);
            this.text = text;
        }

        @Override
        public void renderContents(class_310 mc, class_4587 ms, class_4597 buffer) {
            class_327 font = mc.field_1772;
            float scale = 3;
            ms.method_22905(scale, scale, 1);
            ms.method_22904(-4, -3.75, 5);

            int stringWidth = font.method_27525(text);
            float numberScale = (float) font.field_2000 / stringWidth;
            boolean singleDigit = stringWidth < 10;
            if (singleDigit)
                numberScale = numberScale / 2;
            float verticalMargin = (stringWidth - font.field_2000) / 2f;

            ms.method_22905(numberScale, numberScale, numberScale);
            ms.method_46416(singleDigit ? stringWidth / 2 : 0, singleDigit ? -verticalMargin : verticalMargin, 0);

            int overrideColor = transform.getOverrideColor();
            if (overrideColor == -1)
                drawString8x(ms, buffer, text, 0, 0, 0xFFEDEDED);
            else
                drawString(ms, buffer, text, 0, 0, overrideColor);
        }

    }

    public static class IconValueBox extends ValueBox {
        AllIcons icon;

        public IconValueBox(class_2561 label, INamedIconOptions iconValue, class_238 bb, class_2338 pos) {
            super(label, bb, pos);
            icon = iconValue.getIcon();
        }

        @Override
        public void renderContents(class_310 mc, class_4587 ms, class_4597 buffer) {
            float scale = 2 * 16;
            ms.method_22905(scale, scale, scale);
            ms.method_46416(-.5f, -.5f, 5 / 32f);

            int overrideColor = transform.getOverrideColor();
            icon.render(ms, buffer, overrideColor != -1 ? overrideColor : 0xFFFFFF);
        }

    }

    private static void drawString(class_4587 ms, class_4597 buffer, class_2561 text, float x, float y, int color) {
        class_310.method_1551().field_1772.method_27522(
            text,
            x,
            y,
            color,
            false,
            ms.method_23760().method_23761(),
            buffer,
            class_327.class_6415.field_33993,
            0,
            class_765.field_32767
        );
    }

    private static void drawString8x(class_4587 ms, class_4597 buffer, class_2561 text, float x, float y, int color) {
        class_310.method_1551().field_1772.method_37296(
            text.method_30937(),
            x,
            y,
            color,
            0xff333333,
            ms.method_23760().method_23761(),
            buffer,
            class_765.field_32767
        );
    }

}
