package com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip;

import com.zurrtum.create.client.foundation.item.TooltipHelper;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.kinetics.base.IRotate.StressImpact;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity.Mode;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_5244;

public class DeployerTooltipBehaviour extends KineticTooltipBehaviour<DeployerBlockEntity> {
    public DeployerTooltipBehaviour(DeployerBlockEntity be) {
        super(be);
    }

    @Override
    public boolean addToTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        if (super.addToTooltip(tooltip, isPlayerSneaking))
            return true;
        if (blockEntity.getSpeed() == 0)
            return false;
        if (blockEntity.overflowItems.isEmpty())
            return false;
        TooltipHelper.addHint(tooltip, "hint.full_deployer");
        return true;
    }

    @Override
    public boolean addToGoggleTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate("tooltip.deployer.header").forGoggles(tooltip);

        CreateLang.translate("tooltip.deployer." + (blockEntity.mode == Mode.USE ? "using" : "punching")).style(class_124.field_1054)
            .forGoggles(tooltip);

        class_1799 heldItem = blockEntity.heldItem;
        if (!heldItem.method_7960())
            CreateLang.translate("tooltip.deployer.contains", heldItem.method_7964(), heldItem.method_7947()).style(class_124.field_1060).forGoggles(tooltip);

        float stressAtBase = blockEntity.calculateStressApplied();
        if (StressImpact.isEnabled() && !class_3532.method_15347(stressAtBase, 0)) {
            tooltip.add(class_5244.field_39003);
            addStressImpactStats(tooltip, stressAtBase);
        }

        return true;
    }
}
