package com.zurrtum.create.client.foundation.blockEntity.behaviour.tooltip;

import com.zurrtum.create.client.content.contraptions.IDisplayAssemblyExceptions;
import com.zurrtum.create.client.foundation.item.TooltipHelper;
import com.zurrtum.create.content.contraptions.AssemblyException;
import com.zurrtum.create.content.contraptions.bearing.BearingBlock;
import com.zurrtum.create.content.contraptions.bearing.MechanicalBearingBlockEntity;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2680;

public class MechanicalBearingTooltipBehaviour extends GeneratingKineticTooltipBehaviour<MechanicalBearingBlockEntity> implements IDisplayAssemblyExceptions {
    public MechanicalBearingTooltipBehaviour(MechanicalBearingBlockEntity be) {
        super(be);
    }

    @Override
    public boolean addToTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        if (super.addToTooltip(tooltip, isPlayerSneaking))
            return true;
        if (isPlayerSneaking)
            return false;
        if (!blockEntity.isWindmill() && blockEntity.getSpeed() == 0)
            return false;
        if (blockEntity.isRunning())
            return false;
        class_2680 state = blockEntity.method_11010();
        if (!(state.method_26204() instanceof BearingBlock))
            return false;

        class_2680 attachedState = blockEntity.method_10997().method_8320(blockEntity.method_11016().method_10093(state.method_11654(BearingBlock.FACING)));
        if (attachedState.method_45474())
            return false;
        TooltipHelper.addHint(tooltip, "hint.empty_bearing");
        return true;
    }

    @Override
    public AssemblyException getLastAssemblyException() {
        return blockEntity.getLastAssemblyException();
    }
}
