package com.zurrtum.create.client.foundation.fluid;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllFluidConfigs;
import com.zurrtum.create.client.catnip.render.FluidRenderHelper;
import com.zurrtum.create.client.infrastructure.fluid.FluidConfig;
import net.minecraft.class_1058;
import net.minecraft.class_2350;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_7833;
import net.minecraft.class_9326;

public class FluidRenderer {
    public static void renderFluidStream(
        class_3611 fluid,
        class_9326 changes,
        class_2350 direction,
        float radius,
        float progress,
        boolean inbound,
        class_4588 builder,
        class_4587.class_4665 entry,
        int light
    ) {
        FluidConfig config = AllFluidConfigs.get(fluid);
        if (config == null) {
            return;
        }
        class_1058 flowTexture = config.flowing().get();
        class_1058 stillTexture = config.still().get();

        int color = config.tint().apply(changes) | 0xff000000;
        int blockLightIn = (light >> 4) & 0xF;
        int luminosity = Math.max(blockLightIn, fluid.method_15785().method_15759().method_26213());
        light = (light & 0xF00000) | luminosity << 4;

        if (inbound)
            direction = direction.method_10153();

        entry = entry.method_56822();
        entry.method_67796(0.5f, 0.5f, 0.5f);
        entry.method_67798(class_7833.field_40716.rotation(class_3532.field_29847 * AngleHelper.horizontalAngle(direction)));
        entry.method_67798(class_7833.field_40714.rotation(class_3532.field_29847 * (direction == class_2350.field_11036 ? 180 : direction == class_2350.field_11033 ? 0 : 270)));
        entry.method_67796(0, -0.5f, 0);

        float hMin = -radius;
        float y = inbound ? 1 : .5f;
        float yMin = y - class_3532.method_15363(progress * .5f, 0, 1);

        for (int i = 0; i < 4; i++) {
            renderFlowingTiledFace(class_2350.field_11035, hMin, yMin, radius, y, radius, builder, entry, light, color, flowTexture);
            entry.method_67798(class_7833.field_40716.rotation(class_3532.field_29847 * 90));
        }

        if (progress != 1) {
            FluidRenderHelper.renderStillTiledFace(class_2350.field_11033, hMin, hMin, radius, radius, yMin, builder, entry, light, color, stillTexture);
        }
    }

    public static void renderFlowingTiledFace(
        class_2350 dir,
        float left,
        float down,
        float right,
        float up,
        float depth,
        class_4588 builder,
        class_4587.class_4665 entry,
        int light,
        int color,
        class_1058 texture
    ) {
        FluidRenderHelper.renderTiledFace(dir, left, down, right, up, depth, builder, entry, light, color, texture, 0.5f);
    }
}
