package com.zurrtum.create.client.foundation.gui.widget;

import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.catnip.gui.element.ScreenElement;
import com.zurrtum.create.client.catnip.gui.widget.AbstractSimiWidget;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_332;

public class IconButton extends AbstractSimiWidget {

    protected ScreenElement icon;

    public boolean green;

    public IconButton(int x, int y, ScreenElement icon) {
        this(x, y, 18, 18, icon);
    }

    public IconButton(int x, int y, int w, int h, ScreenElement icon) {
        super(x, y, w, h);
        this.icon = icon;
    }

    @Override
    public void doRender(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (field_22764) {
            field_22762 = mouseX >= method_46426() && mouseY >= method_46427() && mouseX < method_46426() + field_22758 && mouseY < method_46427() + field_22759;

            AllGuiTextures button = !field_22763 ? AllGuiTextures.BUTTON_DISABLED : field_22762 && AllKeys.isMouseButtonDown(0) ? AllGuiTextures.BUTTON_DOWN : field_22762 ? AllGuiTextures.BUTTON_HOVER : green ? AllGuiTextures.BUTTON_GREEN : AllGuiTextures.BUTTON;

            drawBg(graphics, button);
            icon.render(graphics, method_46426() + 1, method_46427() + 1);
        }
    }

    protected void drawBg(class_332 graphics, AllGuiTextures button) {
        graphics.method_25290(
            class_10799.field_56883,
            button.location,
            method_46426(),
            method_46427(),
            button.getStartX(),
            button.getStartY(),
            button.getWidth(),
            button.getHeight(),
            256,
            256
        );
    }

    public void setToolTip(class_2561 text) {
        toolTip.clear();
        toolTip.add(text);
    }

    public void setIcon(ScreenElement icon) {
        this.icon = icon;
    }
}
