package com.zurrtum.create.client.foundation.gui.widget;

import com.zurrtum.create.client.catnip.gui.widget.AbstractSimiWidget;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class Label extends AbstractSimiWidget {

    public class_2561 text;
    public String suffix;
    protected boolean hasShadow;
    protected int color;
    protected class_327 font;

    public Label(int x, int y, class_2561 text) {
        super(x, y, class_310.method_1551().field_1772.method_27525(text), 10);
        font = class_310.method_1551().field_1772;
        this.text = class_2561.method_43470("Label");
        color = 0xFFFFFFFF;
        hasShadow = false;
        suffix = "";
    }

    public Label colored(int color) {
        this.color = color;
        return this;
    }

    public Label withShadow() {
        this.hasShadow = true;
        return this;
    }

    public Label withSuffix(String s) {
        suffix = s;
        return this;
    }

    public void setTextAndTrim(class_2561 newText, boolean trimFront, int maxWidthPx) {
        class_327 fontRenderer = class_310.method_1551().field_1772;

        if (fontRenderer.method_27525(newText) <= maxWidthPx) {
            text = newText;
            return;
        }

        String trim = "...";
        int trimWidth = fontRenderer.method_1727(trim);

        String raw = newText.getString();
        StringBuilder builder = new StringBuilder(raw);
        int startIndex = trimFront ? 0 : raw.length() - 1;
        int endIndex = !trimFront ? 0 : raw.length() - 1;
        int step = (int) Math.signum(endIndex - startIndex);

        for (int i = startIndex; i != endIndex; i += step) {
            String sub = builder.substring(trimFront ? i : startIndex, trimFront ? endIndex + 1 : i + 1);
            if (fontRenderer.method_27525(class_2561.method_43470(sub).method_10862(newText.method_10866())) + trimWidth <= maxWidthPx) {
                text = class_2561.method_43470(trimFront ? trim + sub : sub + trim).method_10862(newText.method_10866());
                return;
            }
        }

    }

    @Override
    protected void doRender(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        if (text == null || text.getString().isEmpty())
            return;

        class_5250 copy = text.method_27662();
        if (suffix != null && !suffix.isEmpty())
            copy.method_27693(suffix);

        graphics.method_51439(font, copy, method_46426(), method_46427(), color, hasShadow);
    }

}
