package com.zurrtum.create.client.infrastructure.fluid;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1058;
import net.minecraft.class_9326;

public record FluidConfig(
    Supplier<class_1058> still, Supplier<class_1058> flowing, Function<class_9326, Integer> tint, Supplier<Float> fogDistance, int fogColor
) {
    private static final Map<FluidConfig, class_1058[]> CACHE = new IdentityHashMap<>();

    public FluidConfig(Supplier<class_1058> still, Supplier<class_1058> flowing, Function<class_9326, Integer> tint) {
        this(still, flowing, tint, () -> 0f, -1);
    }

    public class_1058[] toSprite() {
        return CACHE.computeIfAbsent(this, config -> new class_1058[]{config.still.get(), config.flowing.get()});
    }
}
