package com.zurrtum.create.client.infrastructure.particle;

import net.minecraft.class_11944;
import net.minecraft.class_2338;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4184;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.minecraft.class_708;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_9848;
import net.minecraft.client.particle.*;
import net.minecraft.util.math.*;
import org.joml.Quaternionf;

public class SteamJetParticle extends class_708 {
    private final float yaw;
    private final float pitch;

    protected SteamJetParticle(
        class_638 world,
        double x,
        double y,
        double z,
        double dx,
        double dy,
        double dz,
        class_4002 sprite,
        class_5819 random
    ) {
        super(world, x, y, z, sprite, random.method_43057() * .5f);
        field_3852 = 0;
        field_3869 = 0;
        field_3850 = 0;
        field_3844 = 0;
        field_17867 = .375f;
        method_3077(21);
        method_3063(x, y, z);
        field_62637 = field_62638 = random.method_43057() * class_3532.field_29844;
        yaw = (float) class_3532.method_15349(dx, dz) - class_3532.field_29844;
        pitch = (float) class_3532.method_15349(dy, Math.sqrt(dx * dx + dz * dz)) - class_3532.field_29844 / 2;
        this.method_74306(sprite);
    }

    @Override
    public class_11941 method_74255() {
        return class_11941.field_62640;
    }

    @Override
    public class_3999 method_74274() {
        return SteamJetParticleRenderer.SHEET;
    }

    @Override
    public void method_3074(class_11944 submittable, class_4184 camera, float tickProgress) {
        class_243 vec3 = camera.method_19326();
        float f = (float) (field_3874 - vec3.field_1352);
        float f1 = (float) (field_3854 - vec3.field_1351);
        float f2 = (float) (field_3871 - vec3.field_1350);
        float f3 = class_3532.method_16439(tickProgress, field_62638, field_62637);
        float f7 = method_18133();
        float f8 = method_18134();
        float f5 = method_18135();
        float f6 = method_18136();
        float f4 = method_18132(tickProgress);
        class_11941 renderType = method_74255();
        int color = class_9848.method_61318(field_62636, field_62633, field_62634, field_62635);
        int brightness = method_3068(tickProgress);
        for (int i = 0; i < 4; i++) {
            Quaternionf rotation = class_7833.field_40716.rotation(yaw);
            rotation.mul(class_7833.field_40714.rotation(pitch));
            rotation.mul(class_7833.field_40716.rotation(f3 + class_3532.field_29844 / 2 * i + field_62637));
            submittable.method_74323(renderType, f, f1, f2, rotation.x, rotation.y, rotation.z, rotation.w, f4, f7, f8, f5, f6, color, brightness);
        }
    }

    @Override
    public int method_3068(float partialTick) {
        class_2338 blockpos = class_2338.method_49637(this.field_3874, this.field_3854, this.field_3871);
        return this.field_3851.method_8477(blockpos) ? class_761.method_23794(field_3851, blockpos) : 0;
    }

    public static class Factory implements class_707<class_2400> {
        private final class_4002 spriteSet;

        public Factory(class_4002 animatedSprite) {
            this.spriteSet = animatedSprite;
        }

        public class_703 createParticle(
            class_2400 type,
            class_638 worldIn,
            double x,
            double y,
            double z,
            double xSpeed,
            double ySpeed,
            double zSpeed,
            class_5819 random
        ) {
            return new SteamJetParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet, random);
        }
    }
}
