package com.zurrtum.create.client.infrastructure.ponder.scenes;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.client.foundation.ponder.CreateSceneBuilder;
import com.zurrtum.create.client.foundation.ponder.element.BeltItemElement;
import com.zurrtum.create.client.ponder.api.PonderPalette;
import com.zurrtum.create.client.ponder.api.element.ElementLink;
import com.zurrtum.create.client.ponder.api.element.EntityElement;
import com.zurrtum.create.client.ponder.api.element.WorldSectionElement;
import com.zurrtum.create.client.ponder.api.scene.SceneBuilder;
import com.zurrtum.create.client.ponder.api.scene.SceneBuildingUtil;
import com.zurrtum.create.client.ponder.api.scene.Selection;
import com.zurrtum.create.content.equipment.sandPaper.SandPaperItem;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlock;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1472;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3730;
import net.minecraft.class_6903;
import net.minecraft.class_8080;

public class DeployerScenes {

    public static void filter(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("deployer", "Using the Deployer");
        scene.configureBasePlate(0, 0, 5);

        class_2338 potPosition = util.grid().at(1, 1, 2);
        class_2338 deployerPos = util.grid().at(3, 1, 2);
        Selection deployerSelection = util.select().position(deployerPos);

        scene.world().setBlock(potPosition, class_2246.field_10124.method_9564(), false);
        scene.world().showSection(util.select().layer(0).add(util.select().position(1, 1, 2)), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(3, 1, 3, 3, 1, 5), class_2350.field_11033);
        scene.idle(10);

        scene.world().showSection(deployerSelection, class_2350.field_11035);
        scene.idle(10);

        scene.overlay().showText(60).placeNearTarget().pointAt(util.vector().topOf(deployerPos))
            .text("Given Rotational Force, a Deployer can imitate player interactions");
        scene.world().moveDeployer(deployerPos, 1, 25);
        scene.idle(26);
        scene.world().moveDeployer(deployerPos, -1, 25);
        scene.idle(44);

        scene.overlay().showOutlineWithText(util.select().position(deployerPos.method_10088(2)), 60)
            .text("It will always interact with the position 2 blocks in front of itself").attachKeyFrame().placeNearTarget()
            .colored(PonderPalette.GREEN).attachKeyFrame();
        scene.world().moveDeployer(deployerPos, 1, 25);
        scene.idle(26);
        scene.world().moveDeployer(deployerPos, -1, 25);
        scene.idle(20);
        scene.world().showSection(util.select().fromTo(2, 1, 3, 2, 1, 1), class_2350.field_11033);
        scene.idle(24);

        scene.overlay().showText(50).pointAt(util.vector().topOf(deployerPos.method_10067())).text("Blocks directly in front will not obstruct it")
            .placeNearTarget();
        scene.world().moveDeployer(deployerPos, 1, 25);
        scene.idle(26);
        scene.world().moveDeployer(deployerPos, -1, 25);
        scene.idle(34);
        scene.world().hideSection(util.select().fromTo(2, 1, 3, 2, 1, 1), class_2350.field_11036);
        scene.idle(20);

        String[] actions = new String[]{"Place Blocks,", "Use Items,", "Activate Blocks,", "Harvest blocks", "and Attack Mobs"};

        scene.overlay().showText(80).attachKeyFrame().independent(40).placeNearTarget().text("Deployers can:");

        int y = 60;
        for (String s : actions) {
            scene.idle(15);
            scene.overlay().showText(50).colored(PonderPalette.MEDIUM).placeNearTarget().independent(y).text(s);
            y += 16;
        }
        scene.idle(50);

        class_1799 pot = new class_1799(class_1802.field_8074);
        class_243 frontVec = util.vector().blockSurface(deployerPos, class_2350.field_11039).method_1031(-.125, 0, 0);

        scene.overlay().showControls(frontVec, Pointing.DOWN, 40).rightClick().withItem(pot);
        scene.idle(7);
        Class<DeployerBlockEntity> teType = DeployerBlockEntity.class;
        scene.world().modifyBlockEntityNBT(
            deployerSelection, teType, nbt -> {
                class_6903<class_2520> ops = scene.world().getHolderLookupProvider().method_57093(class_2509.field_11560);
                nbt.method_67493("HeldItem", class_1799.field_24671, ops, pot);
            }
        );
        scene.idle(10);

        scene.overlay().showText(40).attachKeyFrame().placeNearTarget().pointAt(frontVec).text("Right-click the front to give it an Item to use");
        scene.idle(40);
        scene.world().moveDeployer(deployerPos, 1, 25);
        scene.idle(26);
        scene.world().restoreBlocks(util.select().position(potPosition));
        scene.world().modifyBlockEntityNBT(deployerSelection, teType, nbt -> nbt.method_67494("HeldItem", class_1799.field_49266, class_1799.field_8037));
        scene.world().moveDeployer(deployerPos, -1, 25);
        scene.idle(20);

        scene.world().showSection(util.select().position(deployerPos.method_10084()), class_2350.field_11033);

        class_1799 tulip = new class_1799(class_1802.field_17502);
        class_243 entitySpawn = util.vector().topOf(deployerPos.method_10086(3));

        ElementLink<EntityElement> entity1 = scene.world().createItemEntity(entitySpawn, util.vector().of(0, 0.2, 0), tulip);
        scene.idle(17);
        scene.world().modifyEntity(entity1, class_1297::method_31472);
        scene.world().modifyBlockEntityNBT(
            deployerSelection, teType, nbt -> {
                class_6903<class_2520> ops = scene.world().getHolderLookupProvider().method_57093(class_2509.field_11560);
                nbt.method_67493("HeldItem", class_1799.field_24671, ops, tulip);
            }
        );
        scene.idle(10);
        scene.overlay().showText(40).placeNearTarget().pointAt(util.vector().of(3, 2.5, 3)).text("Items can also be inserted automatically");
        scene.idle(30);
        scene.world().moveDeployer(deployerPos, 1, 25);
        scene.idle(26);
        scene.world().setBlock(potPosition, class_2246.field_10598.method_9564(), false);
        scene.world().modifyBlockEntityNBT(deployerSelection, teType, nbt -> nbt.method_67494("HeldItem", class_1799.field_49266, class_1799.field_8037));
        scene.world().moveDeployer(deployerPos, -1, 25);
        scene.idle(25);
        scene.world().hideSection(util.select().position(potPosition), class_2350.field_11036);
        scene.world().hideSection(util.select().position(deployerPos.method_10084()), class_2350.field_11034);
        scene.idle(20);

        class_243 filterSlot = util.vector().topOf(deployerPos).method_1031(2 / 16f, 0, 0);
        scene.overlay().showFilterSlotInput(filterSlot, class_2350.field_11036, 80);
        scene.overlay().showText(40).attachKeyFrame().placeNearTarget().pointAt(filterSlot).text("Deployers carry a filter slot");
        scene.idle(50);

        class_1799 shears = new class_1799(class_1802.field_8868);

        scene.overlay().showControls(filterSlot, Pointing.DOWN, 40).rightClick().withItem(shears);
        scene.idle(7);
        scene.world().setFilterData(deployerSelection, teType, shears);
        scene.overlay().showText(60).placeNearTarget().pointAt(filterSlot)
            .text("When a filter is set, it activates only while holding a matching item");
        scene.idle(70);

        ElementLink<EntityElement> sheep = scene.world().createEntity(w -> {
            class_1472 entity = class_1299.field_6115.method_5883(w, class_3730.field_52444);
            entity.method_6631(class_1767.field_7954);
            class_243 p = util.vector().topOf(util.grid().at(1, 0, 2));
            entity.method_23327(p.field_1352, p.field_1351, p.field_1350);
            entity.field_6014 = p.field_1352;
            entity.field_6036 = p.field_1351;
            entity.field_5969 = p.field_1350;
            class_8080 animation = entity.field_42108;
            animation.method_48568(-animation.method_48569(), 1, 1);
            animation.method_48567(1);
            entity.field_5982 = 210;
            entity.method_36456(210);
            entity.field_6259 = 210;
            entity.field_6241 = 210;
            return entity;
        });
        scene.idle(20);
        scene.world().showSection(util.select().position(deployerPos.method_10084()), class_2350.field_11039);
        entity1 = scene.world().createItemEntity(entitySpawn, util.vector().of(0, 0.2, 0), shears);
        scene.idle(17);
        scene.world().modifyEntity(entity1, class_1297::method_31472);
        scene.world().modifyBlockEntityNBT(
            deployerSelection, teType, nbt -> {
                class_6903<class_2520> ops = scene.world().getHolderLookupProvider().method_57093(class_2509.field_11560);
                nbt.method_67493("HeldItem", class_1799.field_24671, ops, shears);
            }
        );
        scene.idle(10);

        scene.overlay().showText(60).placeNearTarget().pointAt(util.vector().of(3, 2.5, 3))
            .text("Only items matching the filter can now be inserted...");

        scene.idle(70);
        scene.world().moveDeployer(deployerPos, 1, 25);
        scene.idle(26);
        scene.world().modifyEntity(sheep, e -> ((class_1472) e).method_6635(true));
        scene.effects().emitParticles(
            util.vector().topOf(deployerPos.method_10088(2)).method_1031(0, -.25, 0),
            scene.effects().particleEmitterWithinBlockSpace(
                new class_2388(class_2398.field_11217, class_2246.field_10459.method_9564()),
                util.vector().of(0, 0, 0)
            ),
            25,
            1
        );
        scene.world().moveDeployer(deployerPos, -1, 25);
        scene.world().showSection(util.select().position(deployerPos.method_10095()), class_2350.field_11035);
        scene.idle(25);

        scene.overlay().showText(80).placeNearTarget().pointAt(util.vector().of(3.5, 1.25, 1.25))
            .text("...and only non-matching items will be extracted");
        scene.world().flapFunnel(deployerPos.method_10095(), true);
        scene.world().createItemEntity(
            util.vector().centerOf(deployerPos.method_10095()).method_1023(0, .45, 0),
            util.vector().of(0, 0, -0.1),
            new class_1799(class_1802.field_19050)
        );

        scene.markAsFinished();
        for (int i = 0; i < 10; i++) {
            scene.idle(26);
            scene.world().moveDeployer(deployerPos, 1, 25);
            scene.idle(26);
            scene.world().moveDeployer(deployerPos, -1, 25);
            scene.idle(26);
        }
    }

    public static void modes(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("deployer_modes", "Modes of the Deployer");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(3, 1, 3, 3, 1, 5), class_2350.field_11033);
        scene.idle(10);

        class_2338 deployerPos = util.grid().at(3, 1, 2);
        class_243 frontVec = util.vector().blockSurface(deployerPos, class_2350.field_11039).method_1031(-.125, 0, 0);
        Selection grassBlock = util.select().position(1, 1, 2);

        Selection deployerSelection = util.select().position(deployerPos);
        scene.world().showSection(deployerSelection, class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(grassBlock, class_2350.field_11033);
        scene.idle(10);

        class_1799 tool = new class_1799(class_1802.field_8303);
        scene.overlay().showControls(util.vector().topOf(deployerPos), Pointing.DOWN, 30).withItem(tool);
        scene.idle(7);
        scene.world().modifyBlockEntityNBT(
            deployerSelection, DeployerBlockEntity.class, nbt -> {
                class_6903<class_2520> ops = scene.world().getHolderLookupProvider().method_57093(class_2509.field_11560);
                nbt.method_67493("HeldItem", class_1799.field_24671, ops, tool);
            }
        );
        scene.idle(45);

        scene.world().setKineticSpeed(util.select().position(2, 0, 5), 16);
        scene.world().setKineticSpeed(util.select().layer(1), -32);
        scene.world().moveDeployer(deployerPos, 1, 25);

        scene.overlay().showText(60).attachKeyFrame().placeNearTarget().pointAt(util.vector().topOf(1, 1, 2))
            .text("By default, a Deployer imitates a Right-click interaction");

        scene.idle(26);
        scene.world().replaceBlocks(grassBlock, class_2246.field_10362.method_9564(), false);
        scene.world().moveDeployer(deployerPos, -1, 25);
        scene.idle(46);

        scene.overlay().showControls(frontVec, Pointing.LEFT, 40).rightClick().withItem(AllItems.WRENCH.method_7854());
        scene.idle(7);
        scene.world().modifyBlockEntityNBT(
            deployerSelection,
            DeployerBlockEntity.class,
            nbt -> nbt.method_67494("Mode", DeployerBlockEntity.Mode.CODEC, DeployerBlockEntity.Mode.PUNCH)
        );
        scene.idle(45);

        scene.overlay().showText(60).attachKeyFrame().placeNearTarget().pointAt(util.vector().topOf(1, 1, 2))
            .text("Using a Wrench, it can be set to imitate a Left-click instead");

        class_2338 breakingPos = deployerPos.method_10088(2);
        for (int i = 0; i < 4; i++) {
            scene.idle(26);
            scene.world().moveDeployer(deployerPos, 1, 25);
            scene.idle(26);
            scene.world().incrementBlockBreakingProgress(breakingPos);
            scene.world().incrementBlockBreakingProgress(breakingPos);
            scene.world().incrementBlockBreakingProgress(breakingPos);
            scene.world().moveDeployer(deployerPos, -1, 25);
            if (i == 3)
                scene.world().createItemEntity(util.vector().centerOf(breakingPos), util.vector().of(0, 0, 0), new class_1799(class_2246.field_10566));
            scene.idle(26);

            if (i == 0)
                scene.markAsFinished();
        }
    }

    public static void processing(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("deployer_processing", "Processing Items using Deployers");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);

        ElementLink<WorldSectionElement> depot = scene.world().showIndependentSection(util.select().position(2, 1, 1), class_2350.field_11033);
        scene.world().moveSection(depot, util.vector().of(0, 0, 1), 0);
        scene.idle(10);

        Selection pressS = util.select().position(2, 3, 2);
        class_2338 pressPos = util.grid().at(2, 3, 2);
        class_2338 depotPos = util.grid().at(2, 1, 1);
        scene.world().setKineticSpeed(pressS, 0);
        scene.world().showSection(pressS, class_2350.field_11033);
        scene.idle(10);

        scene.world().showSection(util.select().fromTo(2, 1, 3, 2, 1, 5), class_2350.field_11043);
        scene.idle(3);
        scene.world().showSection(util.select().position(2, 2, 3), class_2350.field_11035);
        scene.idle(3);
        scene.world().showSection(util.select().position(2, 3, 3), class_2350.field_11043);
        scene.world().setKineticSpeed(pressS, -32);
        scene.effects().indicateSuccess(pressPos);
        scene.idle(10);

        class_1799 tool = AllItems.SAND_PAPER.method_7854();
        scene.overlay().showControls(util.vector().blockSurface(pressPos.method_10074(), class_2350.field_11034).method_1031(0, 0.15, 0), Pointing.RIGHT, 30).withItem(tool);
        scene.idle(7);
        scene.world().modifyBlockEntityNBT(
            pressS, DeployerBlockEntity.class, nbt -> {
                class_6903<class_2520> ops = scene.world().getHolderLookupProvider().method_57093(class_2509.field_11560);
                nbt.method_67493("HeldItem", class_1799.field_24671, ops, tool);
            }
        );
        scene.idle(25);

        class_243 pressSide = util.vector().blockSurface(pressPos, class_2350.field_11039);
        scene.overlay().showText(60).pointAt(pressSide).placeNearTarget().attachKeyFrame()
            .text("With a fitting held item, Deployers can process items provided beneath them");
        scene.idle(80);

        scene.overlay().showText(60).pointAt(pressSide.method_1023(0, 2, 0)).placeNearTarget()
            .text("The Input items can be dropped or placed on a Depot under the Deployer");
        scene.idle(50);
        class_1799 quartz = AllItems.ROSE_QUARTZ.method_7854();
        scene.world().createItemOnBeltLike(depotPos, class_2350.field_11043, quartz);
        class_243 depotCenter = util.vector().centerOf(depotPos.method_10072());
        scene.overlay().showControls(depotCenter, Pointing.UP, 30).withItem(quartz);
        scene.idle(10);

        class_243 targetV = util.vector().centerOf(pressPos).method_1023(0, 1.65, 0);

        scene.world().moveDeployer(pressPos, 1, 30);
        scene.idle(30);
        scene.world().moveDeployer(pressPos, -1, 30);
        scene.debug().enqueueCallback(s -> SandPaperItem.spawnParticles(targetV, quartz, s.getWorld()));
        // particle
        scene.world().removeItemsFromBelt(depotPos);
        class_1799 polished = AllItems.POLISHED_ROSE_QUARTZ.method_7854();
        scene.world().createItemOnBeltLike(depotPos, class_2350.field_11036, polished);
        scene.idle(10);
        scene.overlay().showControls(depotCenter, Pointing.UP, 50).withItem(polished);
        scene.idle(60);

        scene.world().hideIndependentSection(depot, class_2350.field_11043);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(0, 1, 3, 0, 2, 3), class_2350.field_11033);
        scene.idle(10);
        scene.world().showSection(util.select().fromTo(4, 1, 2, 0, 2, 2), class_2350.field_11035);
        scene.idle(20);
        class_2338 beltPos = util.grid().at(0, 1, 2);
        scene.overlay().showText(40).pointAt(util.vector().blockSurface(beltPos, class_2350.field_11039)).placeNearTarget().attachKeyFrame()
            .text("When items are provided on a belt...");
        scene.idle(30);

        ElementLink<BeltItemElement> ingot = scene.world().createItemOnBelt(beltPos, class_2350.field_11035, quartz);
        scene.idle(15);
        ElementLink<BeltItemElement> ingot2 = scene.world().createItemOnBelt(beltPos, class_2350.field_11035, quartz);
        scene.idle(15);
        scene.world().stallBeltItem(ingot, true);
        scene.world().moveDeployer(pressPos, 1, 30);

        scene.overlay().showText(50).pointAt(pressSide).placeNearTarget().attachKeyFrame()
            .text("The Deployer will hold and process them automatically");

        scene.idle(30);
        scene.world().moveDeployer(pressPos, -1, 30);
        scene.debug().enqueueCallback(s -> SandPaperItem.spawnParticles(targetV, quartz, s.getWorld()));
        scene.world().removeItemsFromBelt(pressPos.method_10087(2));
        ingot = scene.world().createItemOnBelt(pressPos.method_10087(2), class_2350.field_11036, polished);
        scene.world().stallBeltItem(ingot, true);
        scene.idle(15);
        scene.world().stallBeltItem(ingot, false);
        scene.idle(15);
        scene.world().stallBeltItem(ingot2, true);
        scene.world().moveDeployer(pressPos, 1, 30);
        scene.idle(30);
        scene.world().moveDeployer(pressPos, -1, 30);
        scene.debug().enqueueCallback(s -> SandPaperItem.spawnParticles(targetV, quartz, s.getWorld()));
        scene.world().removeItemsFromBelt(pressPos.method_10087(2));
        ingot2 = scene.world().createItemOnBelt(pressPos.method_10087(2), class_2350.field_11036, polished);
        scene.world().stallBeltItem(ingot2, true);
        scene.idle(15);
        scene.world().stallBeltItem(ingot2, false);
    }

    public static void redstone(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("deployer_redstone", "Controlling Deployers with Redstone");
        scene.configureBasePlate(0, 0, 5);
        scene.world().showSection(util.select().layer(0), class_2350.field_11036);
        scene.idle(5);
        scene.world().showSection(util.select().fromTo(3, 1, 5, 3, 1, 3), class_2350.field_11033);

        class_2338 deployerPos = util.grid().at(3, 1, 3);
        Selection redstone = util.select().fromTo(3, 1, 1, 3, 1, 2);
        class_2338 leverPos = util.grid().at(3, 1, 1);

        scene.world().toggleRedstonePower(redstone);

        scene.idle(26);
        scene.world().moveDeployer(deployerPos, 1, 30);
        scene.idle(31);
        scene.world().moveDeployer(deployerPos, -1, 30);
        scene.world().showSection(redstone, class_2350.field_11035);
        scene.idle(31);

        scene.world().toggleRedstonePower(redstone);
        scene.effects().indicateRedstone(leverPos);
        scene.idle(10);

        scene.overlay().showText(60).colored(PonderPalette.RED).attachKeyFrame().pointAt(util.vector().topOf(deployerPos)).placeNearTarget()
            .text("When powered by Redstone, Deployers will not activate");
        scene.idle(70);

        scene.world().toggleRedstonePower(redstone);
        scene.idle(10);
        scene.world().moveDeployer(deployerPos, 1f, 30);
        scene.idle(10);

        scene.world().toggleRedstonePower(redstone);
        scene.effects().indicateRedstone(leverPos);
        scene.idle(21);

        scene.overlay().showText(60).pointAt(util.vector().topOf(deployerPos)).placeNearTarget()
            .text("Before stopping, the Deployer will finish any started cycles");

        scene.world().moveDeployer(deployerPos, -1f, 30);
        scene.idle(70);

        scene.world().toggleRedstonePower(redstone);
        scene.idle(3);
        scene.world().toggleRedstonePower(redstone);
        scene.effects().indicateRedstone(leverPos);
        scene.world().moveDeployer(deployerPos, 1, 30);
        scene.overlay().showText(100).colored(PonderPalette.GREEN).attachKeyFrame().pointAt(util.vector().topOf(deployerPos)).placeNearTarget()
            .text("Thus, a negative pulse can be used to trigger exactly one activation cycle");
        scene.idle(31);
        scene.world().moveDeployer(deployerPos, -1, 30);
        scene.idle(40);

    }

    public static void contraption(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        scene.title("deployer_contraption", "Using Deployers on Contraptions");
        scene.configureBasePlate(0, 0, 6);
        scene.scaleSceneView(.9f);
        Selection flowers = util.select().fromTo(4, 1, 1, 1, 1, 1);
        scene.world().replaceBlocks(flowers, class_2246.field_10124.method_9564(), false);

        Selection kinetics = util.select().fromTo(5, 1, 6, 5, 1, 3);
        class_2338 deployerPos = util.grid().at(4, 1, 3);
        Selection deployerSelection = util.select().position(deployerPos);

        scene.world().cycleBlockProperty(deployerPos, DeployerBlock.AXIS_ALONG_FIRST_COORDINATE);

        scene.world().showSection(util.select().layer(0).add(flowers), class_2350.field_11036);
        scene.idle(5);

        ElementLink<WorldSectionElement> pistonHead = scene.world().showIndependentSection(util.select().fromTo(5, 1, 2, 8, 1, 2), class_2350.field_11033);
        scene.world().moveSection(pistonHead, util.vector().of(0, 0, 1), 0);
        scene.world().showSection(kinetics, class_2350.field_11033);
        scene.idle(5);

        ElementLink<WorldSectionElement> contraption = scene.world().showIndependentSection(deployerSelection, class_2350.field_11033);
        scene.idle(5);
        scene.world().glueBlockOnto(util.grid().at(4, 2, 3), class_2350.field_11033, contraption);

        scene.overlay().showText(60).attachKeyFrame().placeNearTarget().pointAt(util.vector().blockSurface(deployerPos, class_2350.field_11039))
            .text("Whenever Deployers are moved as part of an animated Contraption...");
        scene.idle(70);

        scene.world().setKineticSpeed(util.select().position(4, 0, 6), -8);
        scene.world().setKineticSpeed(kinetics, 16);
        scene.world().moveSection(pistonHead, util.vector().of(-3, 0, 0), 100);
        scene.world().moveSection(contraption, util.vector().of(-3, 0, 0), 100);

        for (int x = 0; x < 4; x++) {
            scene.world().moveDeployer(deployerPos, 1, 9);
            scene.idle(10);
            scene.world().moveDeployer(deployerPos, -1, 9);
            scene.world().restoreBlocks(util.select().position(4 - x, 1, 1));
            scene.idle(18);
        }

        scene.overlay().showOutlineWithText(flowers, 90).attachKeyFrame().colored(PonderPalette.GREEN)
            .text("They activate at each visited location, using items from inventories anywhere on the contraption");
        scene.idle(100);

        scene.world().hideSection(flowers, class_2350.field_11036);
        scene.idle(15);
        scene.world().replaceBlocks(flowers, class_2246.field_10124.method_9564(), false);
        scene.world().showSection(flowers, class_2350.field_11036);

        class_243 filterSlot = util.vector().blockSurface(deployerPos.method_10088(3), class_2350.field_11039).method_1031(0, 0, 2 / 16f);
        scene.overlay().showFilterSlotInput(filterSlot, class_2350.field_11039, 80);
        scene.overlay().showText(60).attachKeyFrame().placeNearTarget().pointAt(filterSlot)
            .text("The Filter slot can be used to specify which items to pull");
        scene.idle(70);

        class_1799 poppy = new class_1799(class_1802.field_8880);
        scene.overlay().showControls(filterSlot, Pointing.DOWN, 30).withItem(poppy);
        scene.idle(7);
        scene.world().setFilterData(deployerSelection, DeployerBlockEntity.class, poppy);
        scene.idle(25);

        scene.world().setKineticSpeed(util.select().position(4, 0, 6), 8);
        scene.world().setKineticSpeed(kinetics, -16);
        scene.world().moveSection(pistonHead, util.vector().of(3, 0, 0), 100);
        scene.world().moveSection(contraption, util.vector().of(3, 0, 0), 100);

        for (int x = 0; x < 4; x++) {
            scene.world().moveDeployer(deployerPos, 1, 9);
            scene.idle(10);
            scene.world().moveDeployer(deployerPos, -1, 9);
            scene.world().setBlock(util.grid().at(1 + x, 1, 1), class_2246.field_10449.method_9564(), false);
            scene.idle(18);
        }

    }

}