package com.zurrtum.create.client.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.brigadier.CommandDispatcher;
import com.zurrtum.create.client.flywheel.impl.FlwCommands;
import com.zurrtum.create.foundation.blockEntity.SyncedBlockEntity;
import net.minecraft.class_11368;
import net.minecraft.class_2172;
import net.minecraft.class_2586;
import net.minecraft.class_2641;
import net.minecraft.class_634;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_634.class)
public class ClientPlayNetworkHandlerMixin {
    @Shadow
    private CommandDispatcher<class_2172> commandDispatcher;

    @Inject(method = "onCommandTree(Lnet/minecraft/network/packet/s2c/play/CommandTreeS2CPacket;)V", at = @At("TAIL"))
    private void addCommand(class_2641 packet, CallbackInfo ci) {
        FlwCommands.registerClientCommands(commandDispatcher);
    }

    @WrapOperation(method = "method_38542(Lnet/minecraft/network/packet/s2c/play/BlockEntityUpdateS2CPacket;Lnet/minecraft/block/entity/BlockEntity;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/block/entity/BlockEntity;read(Lnet/minecraft/storage/ReadView;)V"))
    private void onDataPacket(class_2586 blockEntity, class_11368 view, Operation<Void> original) {
        if (blockEntity instanceof SyncedBlockEntity syncedBlockEntity) {
            syncedBlockEntity.onDataPacket(view);
        } else {
            original.call(blockEntity, view);
        }
    }
}
