package com.zurrtum.create.client.mixin;

import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1065;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3268;
import net.minecraft.class_3272;
import net.minecraft.class_3288;
import net.minecraft.class_5352;
import net.minecraft.class_7662;
import net.minecraft.class_7665;
import net.minecraft.class_9224;
import net.minecraft.class_9225;
import net.minecraft.class_9226;
import net.minecraft.resource.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;

import static com.zurrtum.create.Create.MOD_ID;

@Mixin(class_1065.class)
public abstract class DefaultClientResourcePackProviderMixin {
    @Inject(method = "forEachProfile(Ljava/util/function/BiConsumer;)V", at = @At("TAIL"))
    private void loadResourcePack(BiConsumer<String, Function<String, class_3288>> consumer, CallbackInfo ci) {
        ModContainer mod = FabricLoader.getInstance().getModContainer(MOD_ID).orElseThrow();
        List<Path> rootPaths = mod.getRootPaths();
        ModMetadata metadata = mod.getMetadata();
        String version = metadata.getVersion().getFriendlyString();
        if (!FabricLoader.getInstance().isModLoaded("fabric-api")) {
            consumer.accept(
                MOD_ID, id -> {
                    String directory = class_3264.field_14188.method_14413();
                    class_9224 info = createInfo(id, metadata.getName(), id, directory, version);
                    class_7662 meta = createMeta(class_2561.method_43471("advancement.create.root"));
                    class_9225 position = new class_9225(true, class_3288.class_3289.field_14281, false);
                    return createPacket(rootPaths, directory, info, meta, position, id, "minecraft", "flywheel", "vanillin", "ponder", "fabric");
                }
            );
        }
        consumer.accept(
            MOD_ID + "_legacy_copper", id -> {
                String directory = "legacy_copper";
                class_9224 info = createInfo(id, "Create legacy copper", MOD_ID, directory, version);
                class_7662 meta = createMeta(class_2561.method_43470("Replacement textures for Vanilla Copper"));
                class_9225 position = new class_9225(false, class_3288.class_3289.field_14280, false);
                return createPacket(rootPaths, directory, info, meta, position, "minecraft");
            }
        );
    }

    private class_3288 createPacket(
        List<Path> rootPaths,
        String directory,
        class_9224 info,
        class_7662 meta,
        class_9225 position,
        String... namespace
    ) {
        class_7665 builder = new class_7665().method_45198(meta).method_45206(namespace);
        for (Path path : rootPaths) {
            builder.method_45201(class_3264.field_14188, path.resolve(directory));
        }
        class_3268 pack = builder.method_45210(info);
        class_3288.class_7680 packFactory = new class_3288.class_7680() {
            @Override
            public class_3262 method_52424(class_9224 info) {
                return pack;
            }

            @Override
            public class_3262 method_52425(class_9224 info, class_3288.class_7679 metadata) {
                return pack;
            }
        };
        return class_3288.method_45275(info, packFactory, class_3264.field_14188, position);
    }

    @Unique
    private static class_9224 createInfo(String id, String name, String namespace, String path, String version) {
        return new class_9224(
            id,
            class_2561.method_43470(name),
            class_5352.field_25348,
            Optional.of(new class_9226(namespace, path, version))
        );
    }

    @Unique
    private static class_7662 createMeta(class_2561 description) {
        return class_7662.method_45174(
            class_3272.field_61155,
            new class_3272(description, class_155.method_16673().method_70592(class_3264.field_14188).method_72318())
        );
    }
}
