package com.zurrtum.create.client.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.zurrtum.create.client.infrastructure.model.WrapperBlockStateModel;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBlockStateModel;
import net.minecraft.class_1087;
import net.minecraft.class_10889;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

import java.util.List;

@Mixin(FabricBlockStateModel.class)
public interface FabricBlockStateModelMixin {
    @WrapOperation(method = "emitQuads(Lnet/fabricmc/fabric/api/renderer/v1/mesh/QuadEmitter;Lnet/minecraft/world/BlockRenderView;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/util/math/random/Random;Ljava/util/function/Predicate;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/model/BlockStateModel;getParts(Lnet/minecraft/util/math/random/Random;)Ljava/util/List;"))
    private List<class_10889> getParts(
        class_1087 instance,
        class_5819 random,
        Operation<List<class_10889>> original,
        @Local(argsOnly = true) class_1920 world,
        @Local(argsOnly = true) class_2338 pos,
        @Local(argsOnly = true) class_2680 state
    ) {
        if (WrapperBlockStateModel.unwrapCompat(instance) instanceof WrapperBlockStateModel wrapper) {
            List<class_10889> list = new ObjectArrayList<>();
            wrapper.addPartsWithInfo(world, pos, state, random, list);
            return list;
        }
        return original.call(instance, random);
    }
}
