package com.zurrtum.create.client.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.placement.PlacementClient;
import com.zurrtum.create.client.content.equipment.armor.CardboardArmorStealthOverlay;
import com.zurrtum.create.client.content.equipment.armor.RemainingAirOverlay;
import com.zurrtum.create.client.content.equipment.blueprint.BlueprintOverlayRenderer;
import com.zurrtum.create.client.content.equipment.goggles.GoggleOverlayRenderer;
import com.zurrtum.create.client.content.equipment.toolbox.ToolboxHandlerClient;
import com.zurrtum.create.client.content.redstone.link.controller.LinkedControllerClientHandler;
import com.zurrtum.create.client.content.trains.TrainHUD;
import com.zurrtum.create.client.content.trains.track.TrackPlacementOverlay;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_329.class)
public class InGameHudMixin {
    @Shadow
    @Final
    private class_310 client;

    @Inject(method = "renderCrosshair(Lnet/minecraft/client/gui/DrawContext;Lnet/minecraft/client/render/RenderTickCounter;)V", at = @At("TAIL"))
    private void renderCrosshair(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        PlacementClient.onRenderCrosshairOverlay(client, context, AnimationTickHolder.getPartialTicksUI(tickCounter));
    }

    @Inject(method = "renderHotbar(Lnet/minecraft/client/gui/DrawContext;Lnet/minecraft/client/render/RenderTickCounter;)V", at = @At("TAIL"))
    private void renderHotbar(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        Create.VALUE_SETTINGS_HANDLER.render(client, context);
        TrackPlacementOverlay.render(client, context);
        GoggleOverlayRenderer.renderOverlay(client, context, tickCounter);
        BlueprintOverlayRenderer.renderOverlay(client, context);
        LinkedControllerClientHandler.renderOverlay(client, context);
        Create.SCHEMATIC_HANDLER.render(client, context, tickCounter);
        ToolboxHandlerClient.renderOverlay(client, context);
    }

    @Inject(method = "renderAirBubbles(Lnet/minecraft/client/gui/DrawContext;Lnet/minecraft/entity/player/PlayerEntity;III)V", at = @At("TAIL"))
    private void renderAirBubbles(class_332 context, class_1657 player, int heartCount, int top, int left, CallbackInfo ci) {
        RemainingAirOverlay.render(client, context);
    }

    @Inject(method = "renderMainHud(Lnet/minecraft/client/gui/DrawContext;Lnet/minecraft/client/render/RenderTickCounter;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/hud/InGameHud;renderMountHealth(Lnet/minecraft/client/gui/DrawContext;)V", shift = At.Shift.AFTER))
    private void renderMainHud(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        TrainHUD.renderOverlay(client, context, tickCounter);
    }

    @WrapOperation(method = "renderMiscOverlays(Lnet/minecraft/client/gui/DrawContext;Lnet/minecraft/client/render/RenderTickCounter;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/hud/InGameHud;renderOverlay(Lnet/minecraft/client/gui/DrawContext;Lnet/minecraft/util/Identifier;F)V", ordinal = 0))
    private void renderMiscOverlays(
        class_329 instance,
        class_332 context,
        class_2960 texture,
        float opacity,
        Operation<Void> original,
        @Local(argsOnly = true) class_9779 tickCounter,
        @Local class_1799 stack
    ) {
        if (stack.method_31574(AllItems.CARDBOARD_HELMET)) {
            original.call(instance, context, texture, CardboardArmorStealthOverlay.getOverlayOpacity(tickCounter));
        } else {
            original.call(instance, context, texture, opacity);
        }
    }
}
