package com.zurrtum.create.client.mixin;

import com.zurrtum.create.client.flywheel.lib.model.baked.DualVertexConsumer;
import com.zurrtum.create.client.flywheel.lib.model.baked.ItemMeshEmitter;
import net.minecraft.class_3879;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4723;
import net.minecraft.class_630;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3879.class)
public abstract class ModelMixin {
    @Shadow
    public abstract class_630 getRootPart();

    @Inject(method = "render(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumer;III)V", at = @At("HEAD"), cancellable = true)
    public void render(class_4587 matrices, class_4588 vertices, int light, int overlay, int color, CallbackInfo ci) {
        if (vertices instanceof ItemMeshEmitter emitter) {
            emitter.emit(getRootPart(), matrices, null, null, light, overlay, color);
            ci.cancel();
        } else if (vertices instanceof class_4723 consumer) {
            if (consumer.field_21730 instanceof ItemMeshEmitter emitter) {
                emitter.emit(getRootPart(), matrices, consumer.field_21731, null, light, overlay, color);
                ci.cancel();
            }
        } else if (vertices instanceof DualVertexConsumer dual) {
            dual.emit(getRootPart(), matrices, null, light, overlay, color);
            ci.cancel();
        }
    }
}
