package com.zurrtum.create.client.mixin;

import com.google.common.collect.Sets;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.zurrtum.create.client.AllExtensions;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.ghostblock.GhostBlocks;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.catnip.render.DefaultSuperRenderTypeBuffer;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import com.zurrtum.create.client.compat.sodium.SodiumCompat;
import com.zurrtum.create.client.content.contraptions.actors.seat.ContraptionPlayerPassengerRotation;
import com.zurrtum.create.client.content.contraptions.minecart.CouplingRenderer;
import com.zurrtum.create.client.content.equipment.clipboard.ClipboardValueSettingsClientHandler;
import com.zurrtum.create.client.content.equipment.symmetryWand.SymmetryHandlerClient;
import com.zurrtum.create.client.content.kinetics.chainConveyor.ChainConveyorInteractionHandler;
import com.zurrtum.create.client.content.trains.entity.CarriageCouplingRenderer;
import com.zurrtum.create.client.content.trains.track.TrackBlockOutline;
import com.zurrtum.create.client.content.trains.track.TrackTargetingClient;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.foundation.block.render.BlockDestructionProgressExtension;
import com.zurrtum.create.client.foundation.block.render.MultiPosDestructionHandler;
import com.zurrtum.create.foundation.block.LightControlBlock;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import net.minecraft.class_11658;
import net.minecraft.class_12074;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3191;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.minecraft.class_761;
import net.minecraft.class_9779;
import net.minecraft.class_9909;
import net.minecraft.class_9916;
import net.minecraft.class_9922;
import net.minecraft.class_9960;
import net.minecraft.client.render.*;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Set;
import java.util.SortedSet;

@Mixin(class_761.class)
public class WorldRendererMixin {
    @Shadow
    private class_638 world;

    @Shadow
    @Final
    private class_9960 framebufferSet;

    @Shadow
    @Final
    private Long2ObjectMap<SortedSet<class_3191>> blockBreakingProgressions;

    @Shadow
    @Final
    private class_310 client;

    /**
     * This gets called when a block is marked for rerender by vanilla.
     */
    @Inject(method = "scheduleBlockRerenderIfNeeded(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;Lnet/minecraft/block/BlockState;)V", at = @At("TAIL"))
    private void flywheel$checkUpdate(class_2338 pos, class_2680 oldState, class_2680 newState, CallbackInfo ci) {
        VisualizationManager manager = VisualizationManager.get(world);
        if (manager == null) {
            return;
        }

        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity == null) {
            return;
        }

        var blockEntities = manager.blockEntities();
        if (oldState != newState) {
            blockEntities.queueRemove(blockEntity);
            blockEntities.queueAdd(blockEntity);
        } else {
            // I don't think this is possible to reach in vanilla
            blockEntities.queueUpdate(blockEntity);
        }
    }

    @Inject(method = "render(Lnet/minecraft/client/util/ObjectAllocator;Lnet/minecraft/client/render/RenderTickCounter;ZLnet/minecraft/client/render/Camera;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;Lorg/joml/Matrix4f;Lcom/mojang/blaze3d/buffers/GpuBufferSlice;Lorg/joml/Vector4f;Z)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/option/GameOptions;getCloudRenderModeValue()Lnet/minecraft/client/option/CloudRenderMode;"))
    private void renderAfterParticles(
        class_9922 allocator,
        class_9779 tickCounter,
        boolean renderBlockOutline,
        class_4184 camera,
        Matrix4f positionMatrix,
        Matrix4f matrix4f,
        Matrix4f projectionMatrix,
        GpuBufferSlice fogBuffer,
        Vector4f fogColor,
        boolean renderSky,
        CallbackInfo ci,
        @Local class_9909 frameGraphBuilder,
        @Local float tickProgress
    ) {
        class_9916 framePass = frameGraphBuilder.method_61911("after_particles");
        this.framebufferSet.field_53091 = framePass.method_61933(this.framebufferSet.field_53091);
        framePass.method_61929(() -> {
            class_4587 ms = new class_4587();
            class_243 cameraPos = camera.method_19326();
            SuperRenderTypeBuffer buffer = DefaultSuperRenderTypeBuffer.getInstance();
            GhostBlocks.getInstance().renderAll(client, ms, buffer, cameraPos);
            Outliner.getInstance().renderOutlines(client, ms, buffer, cameraPos, tickProgress);
            TrackBlockOutline.drawCurveSelection(client, ms, buffer, cameraPos);
            TrackTargetingClient.render(client, ms, buffer, cameraPos);
            CouplingRenderer.renderAll(client, ms, buffer, cameraPos);
            CarriageCouplingRenderer.renderAll(client, ms, buffer, cameraPos);
            Create.SCHEMATIC_HANDLER.render(client, ms, buffer, cameraPos);
            ChainConveyorInteractionHandler.drawCustomBlockSelection(ms, buffer, cameraPos);
            SymmetryHandlerClient.onRenderWorld(client, ms, buffer, cameraPos);
            buffer.draw();
            client.field_1773.method_72911().method_73002();
            ContraptionPlayerPassengerRotation.frame(client);
        });
    }

    @Inject(method = "setBlockBreakingInfo(ILnet/minecraft/util/math/BlockPos;I)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/entity/player/BlockBreakingInfo;setLastUpdateTick(I)V"))
    private void onDestroyBlockProgress(int entityId, class_2338 pos, int progress, CallbackInfo ci, @Local class_3191 progressObj) {
        class_2680 state = world.method_8320(pos);
        MultiPosDestructionHandler handler = AllExtensions.MULTI_POS.get(state.method_26204());
        if (handler != null) {
            Set<class_2338> extraPositions = handler.getExtraPositions(world, pos, state, progress);
            if (extraPositions != null) {
                extraPositions.remove(pos);
                ((BlockDestructionProgressExtension) progressObj).create$setExtraPositions(extraPositions);
                for (class_2338 extraPos : extraPositions) {
                    blockBreakingProgressions.computeIfAbsent(extraPos.method_10063(), l -> Sets.newTreeSet()).add(progressObj);
                }
            }
        }
    }

    @Inject(method = "removeBlockBreakingInfo(Lnet/minecraft/entity/player/BlockBreakingInfo;)V", at = @At("RETURN"))
    private void onRemoveProgress(class_3191 progress, CallbackInfo ci) {
        Set<class_2338> extraPositions = ((BlockDestructionProgressExtension) progress).create$getExtraPositions();
        if (extraPositions != null) {
            for (class_2338 extraPos : extraPositions) {
                long l = extraPos.method_10063();
                Set<class_3191> set = blockBreakingProgressions.get(l);
                if (set != null) {
                    set.remove(progress);
                    if (set.isEmpty()) {
                        blockBreakingProgressions.remove(l);
                    }
                }
            }
        }
    }

    @Inject(method = "renderTargetBlockOutline(Lnet/minecraft/client/render/VertexConsumerProvider$Immediate;Lnet/minecraft/client/util/math/MatrixStack;ZLnet/minecraft/client/render/state/WorldRenderState;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/render/state/OutlineRenderState;highContrast()Z", ordinal = 0), cancellable = true)
    private void onRenderBlockOutline(
        class_4597.class_4598 vertexConsumers,
        class_4587 matrices,
        boolean renderBlockOutline,
        class_11658 renderStates,
        CallbackInfo ci,
        @Local class_243 cameraPos,
        @Local class_12074 state
    ) {
        if (ChainConveyorInteractionHandler.hideVanillaBlockSelection() || ClipboardValueSettingsClientHandler.drawCustomBlockSelection(
            client,
            state.comp_4932(),
            vertexConsumers,
            cameraPos,
            matrices
        ) || TrackBlockOutline.drawCustomBlockSelection(client, state.comp_4932(), vertexConsumers, cameraPos, matrices)) {
            ci.cancel();
        }
    }

    @WrapOperation(method = "getLightmapCoordinates(Lnet/minecraft/client/render/WorldRenderer$BrightnessGetter;Lnet/minecraft/world/BlockRenderView;Lnet/minecraft/block/BlockState;Lnet/minecraft/util/math/BlockPos;)I", at = @At(value = "INVOKE", target = "Lnet/minecraft/block/BlockState;getLuminance()I"))
    private static int getLuminance(
        class_2680 state,
        Operation<Integer> original,
        @Local(argsOnly = true) class_1920 world,
        @Local(argsOnly = true) class_2338 pos
    ) {
        if (state.method_26204() instanceof LightControlBlock block) {
            return block.getLuminance(world, pos);
        }
        return original.call(state);
    }

    @Inject(method = "renderBlockEntities(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/state/WorldRenderState;Lnet/minecraft/client/render/command/OrderedRenderCommandQueueImpl;)V", at = @At("HEAD"))
    private void markSpriteActive(CallbackInfo ci) {
        SodiumCompat.markSpriteActive(client);
    }
}
