/*
 * Copyright (c) NeoForged and contributors
 * SPDX-License-Identifier: LGPL-2.1-only
 */

package com.zurrtum.create.client.model;

import net.minecraft.class_10419;
import net.minecraft.class_10802;
import net.minecraft.class_10813;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3665;
import net.minecraft.class_7775;
import net.minecraft.class_809;
import net.minecraft.client.render.model.*;
import org.jetbrains.annotations.Nullable;

/**
 * Base unbaked model for custom models which support the standard top-level model parameters
 * added by vanilla and NeoForge except elements but create the quads from something other
 * than the vanilla elements spec.
 */
public abstract class AbstractUnbakedModel implements class_1100 {
    /**
     * Holds the standard top-level model parameters except elements.
     * {@link class_10802#bake(class_10419, class_7775, class_3665, class_10813)}
     * must always use the values given as parameters instead of accessing this parameter directly in order to
     * take values collected along the model's parent chain into account.
     */
    protected final StandardModelParameters parameters;

    protected AbstractUnbakedModel(StandardModelParameters parameters) {
        this.parameters = parameters;
    }

    @Nullable
    @Override
    public Boolean comp_3741() {
        return this.parameters.ambientOcclusion();
    }

    @Nullable
    @Override
    public class_4751 comp_3740() {
        return this.parameters.guiLight();
    }

    @Nullable
    @Override
    public class_809 comp_3742() {
        return this.parameters.itemTransforms();
    }

    @Override
    public class_10419.class_10420 comp_3743() {
        return this.parameters.textures();
    }

    @Nullable
    @Override
    public class_2960 comp_3744() {
        return this.parameters.parent();
    }
}
