package com.zurrtum.create.client.ponder.foundation.element;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.ponder.api.element.ParrotElement;
import com.zurrtum.create.client.ponder.api.element.ParrotPose;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.client.ponder.foundation.PonderScene;
import org.jetbrains.annotations.Nullable;

import java.util.function.Supplier;
import net.minecraft.class_10017;
import net.minecraft.class_10442;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1453;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import net.minecraft.class_898;

public class ParrotElementImpl extends AnimatedSceneElementBase implements ParrotElement {

    protected class_243 location;
    @Nullable
    protected class_1453 entity;
    protected ParrotPose pose;
    protected Supplier<? extends ParrotPose> initialPose;

    public static ParrotElement create(class_243 location, Supplier<? extends ParrotPose> pose) {
        return new ParrotElementImpl(location, pose);
    }

    protected ParrotElementImpl(class_243 location, Supplier<? extends ParrotPose> pose) {
        this.location = location;
        initialPose = pose;
        this.pose = initialPose.get();
    }

    @Override
    public void reset(PonderScene scene) {
        super.reset(scene);
        setPose(initialPose.get());
        entity.method_23327(0, 0, 0);
        entity.field_6014 = 0;
        entity.field_6036 = 0;
        entity.field_5969 = 0;
        entity.field_6038 = 0;
        entity.field_5971 = 0;
        entity.field_5989 = 0;
        entity.method_36457(entity.field_6004 = 0);
        entity.method_36456(entity.field_5982 = 180);
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        if (entity == null) {
            entity = pose.create(scene.getWorld());
            entity.method_36456(entity.field_5982 = 180);
        }

        entity.field_6012++;
        entity.field_6259 = entity.field_6241;
        entity.field_6827 = entity.field_6819;
        entity.field_6829 = entity.field_6818;
        entity.method_24830(true);

        entity.field_6014 = entity.method_23317();
        entity.field_6036 = entity.method_23318();
        entity.field_5969 = entity.method_23321();
        entity.field_5982 = entity.method_36454();
        entity.field_6004 = entity.method_36455();

        pose.tick(scene, entity, location);

        entity.field_6038 = entity.method_23317();
        entity.field_5971 = entity.method_23318();
        entity.field_5989 = entity.method_23321();
    }

    @Override
    public void setPositionOffset(class_243 position, boolean immediate) {
        if (entity == null)
            return;
        entity.method_23327(position.field_1352, position.field_1351, position.field_1350);
        if (!immediate)
            return;
        entity.field_6014 = position.field_1352;
        entity.field_6036 = position.field_1351;
        entity.field_5969 = position.field_1350;
    }

    @Override
    public void setRotation(class_243 eulers, boolean immediate) {
        if (entity == null)
            return;
        entity.method_36457((float) eulers.field_1352);
        entity.method_36456((float) eulers.field_1351);
        if (!immediate)
            return;
        entity.field_6004 = entity.method_36455();
        entity.field_6036 = entity.method_36454();
    }

    @Override
    public class_243 getPositionOffset() {
        return entity != null ? entity.method_73189() : class_243.field_1353;
    }

    @Override
    public class_243 getRotation() {
        return entity != null ? new class_243(entity.method_36455(), entity.method_36454(), 0) : class_243.field_1353;
    }

    @Override
    protected void renderLast(
        class_898 entityRenderManager,
        class_10442 itemModelManager,
        PonderLevel world,
        class_4597 buffer,
        class_11659 queue,
        class_4184 camera,
        class_12075 cameraRenderState,
        class_4587 poseStack,
        float fade,
        float pt
    ) {
        if (entity == null) {
            entity = pose.create(world);
            entity.method_36456(entity.field_5982 = 180);
        }

        poseStack.method_22903();
        poseStack.method_22904(location.field_1352, location.field_1351, location.field_1350);
        poseStack.method_22904(
            class_3532.method_16436(pt, entity.field_6014, entity.method_23317()),
            class_3532.method_16436(pt, entity.field_6036, entity.method_23318()),
            class_3532.method_16436(pt, entity.field_5969, entity.method_23321())
        );

        float angle = AngleHelper.angleLerp(pt, entity.field_5982, entity.method_36454());
        poseStack.method_22907(class_7833.field_40716.rotationDegrees(angle));

        class_10017 state = entityRenderManager.method_72977(entity, pt);
        state.field_61823.clear();
        entityRenderManager.method_72976(state, cameraRenderState, 0, 0, 0, poseStack, queue);
        poseStack.method_22909();
    }

    @Override
    public void setPose(ParrotPose pose) {
        this.pose = pose;
    }

}