package com.zurrtum.create.client.vanillin;

import com.zurrtum.create.catnip.config.ConfigBase;
import com.zurrtum.create.client.vanillin.compose.*;
import com.zurrtum.create.client.vanillin.config.*;
import com.zurrtum.create.client.vanillin.elements.ShadowElement;
import com.zurrtum.create.client.vanillin.visuals.*;
import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1533;
import net.minecraft.class_1688;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_5599;
import net.minecraft.class_5601;
import net.minecraft.class_5602;
import net.minecraft.class_630;

public class VanillaVisuals {
    public static final Configurator CONFIGURATOR = new Configurator();

    // Stable visuals are enabled by default always.
    public static final boolean STABLE = true;
    // Experimental visuals are enabled by default in dev.
    public static final boolean EXPERIMENTAL = VanillinXplat.INSTANCE.isDevelopmentEnvironment();

    public static void init() {
        builder(class_2591.field_11914).factory(ChestVisual::new).apply(STABLE);
        builder(class_2591.field_11901).factory(ChestVisual::new).apply(STABLE);
        builder(class_2591.field_11891).factory(ChestVisual::new).apply(STABLE);

        builder(class_2591.field_16413).factory(BellVisual::new).apply(STABLE);

        builder(class_2591.field_11896).factory(ShulkerBoxVisual::new).apply(STABLE);

        builder(class_1299.field_42460).factory(BlockDisplayVisual::new).apply(STABLE);

        composable(class_1299.field_42456).with(element(VisualElements.ITEM_DISPLAY).build())
            .shouldVisualize((ctx, e) -> ItemDisplayVisual.shouldVisualize(e)).build().skipVanillaRender(ItemDisplayVisual::shouldVisualize)
            .apply(EXPERIMENTAL);

        minecart(class_1299.field_6126, class_5602.field_27690).apply(STABLE);
        minecart(class_1299.field_6136, class_5602.field_27693).apply(STABLE);
        minecart(class_1299.field_6080, class_5602.field_27567).apply(STABLE);
        minecart(class_1299.field_6058, class_5602.field_27601).apply(STABLE);
        minecart(class_1299.field_6096, class_5602.field_27614).apply(STABLE);
        minecart(class_1299.field_6142, class_5602.field_27657).apply(STABLE);

        composable(class_1299.field_6053).apply(VanillaVisuals::commonElements)
            .with(element(VisualElements.SHADOW).configure(new ShadowElement.Config(0.7f, ShadowElement.Config.DEFAULT_STRENGTH)).build())
            .with(element(VisualElements.FIRE).build()).with(element(VisualElements.TNT_MINECART).build()).build()
            .skipVanillaRender(MinecartVisual::shouldSkipRender).apply(STABLE);

        itemFrame(class_1299.field_6043).apply(EXPERIMENTAL);
        itemFrame(class_1299.field_28401).apply(EXPERIMENTAL);

        composable(class_1299.field_6052).apply(VanillaVisuals::commonElements).with(element(VisualElements.FIRE).build())
            .with(element(VisualElements.SHADOW).configure(new ShadowElement.Config(0.15f, 0.75f)).build())
            .with(element(VisualElements.ITEM_ENTITY).build()).shouldVisualize(((ctx, entity) -> ItemVisual.isSupported(entity))).build()
            .skipVanillaRender(ItemVisual::isSupported).apply(EXPERIMENTAL);

    }

    public static void onReloadModel(class_5599 models) {
        boolean supportChest = models.method_32072(class_5602.field_27689).getClass() == class_630.class;
        Map<class_2591<?>, Configurator.ConfiguredBlockEntity<?>> configurator = CONFIGURATOR.blockEntities;
        Map<String, ConfigBase.ConfigEnum<VisualConfigValue>> blockEntities = VanillinConfig.client().blockEntities;
        Map<String, List<VisualOverride>> blockEntityOverrides = VanillinConfig.overrides().blockEntities();
        reloadType(class_2591.field_11914, configurator, blockEntities, blockEntityOverrides, supportChest);
        reloadType(class_2591.field_11901, configurator, blockEntities, blockEntityOverrides, supportChest);
        reloadType(class_2591.field_11891, configurator, blockEntities, blockEntityOverrides, supportChest);
    }

    private static void reloadType(
        class_2591<?> type,
        Map<class_2591<?>, Configurator.ConfiguredBlockEntity<?>> configurator,
        Map<String, ConfigBase.ConfigEnum<VisualConfigValue>> blockEntities,
        Map<String, List<VisualOverride>> blockEntityOverrides,
        boolean support
    ) {
        Configurator.ConfiguredBlockEntity<?> configured = configurator.get(type);
        String key = configured.configKey();
        VisualConfigValue value = blockEntities.get(key).get();
        if (value == VisualConfigValue.DEFAULT) {
            configured.set(support ? value : VisualConfigValue.DISABLE, blockEntityOverrides.get(key));
        }
    }

    public static <T extends class_1297> void commonElements(EntityBuilder<T> builder) {
        builder.with(element(VisualElements.HITBOX).configure(false).build());
    }

    public static <T extends class_1533> EntityVisualizerBuilder<T> itemFrame(class_1299<T> type) {
        return composable(type).apply(VanillaVisuals::commonElements).with(element(VisualElements.ITEM_FRAME).build())
            .shouldVisualize((ctx, entity) -> ItemFrameVisual.shouldVisualize(entity)).build().skipVanillaRender(ItemFrameVisual::shouldVisualize);
    }

    public static <T extends class_1688> EntityVisualizerBuilder<T> minecart(class_1299<T> type, class_5601 variant) {
        return composable(type).apply(VanillaVisuals::commonElements)
            .with(element(VisualElements.SHADOW).configure(new ShadowElement.Config(0.7f, ShadowElement.Config.DEFAULT_STRENGTH)).build())
            .with(element(VisualElements.FIRE).build()).with(element(VisualElements.MINECART).configure(variant).build()).build()
            .skipVanillaRender(MinecartVisual::shouldSkipRender);
    }

    public static <T extends class_1297> EntityBuilder<T> composable(class_1299<T> entityType) {
        return new EntityBuilder<>(entityType);
    }

    public static <T, C> ConfiguredElementImpl.ConfiguredElementBuilder<T, C> element(VisualElement<T, C> element) {
        return new ConfiguredElementImpl.ConfiguredElementBuilder<>(element);
    }

    public static class EntityBuilder<T extends class_1297> {
        private final List<ConfiguredElement<? super T>> elements = new ArrayList<>();

        private final class_1299<T> entityType;
        @Nullable
        private VisualizationPredicate<T> predicate;

        public EntityBuilder(class_1299<T> entityType) {
            this.entityType = entityType;
        }

        /**
         * Set a predicate to control whether <em>all</em> elements are visualized.
         * <p>This is useful when you can't guarantee than an entity will support visualization for its entire lifetime.
         *
         * @param predicate A visualization predicate, returning {@code true} to indicate the entity should be visualized.
         */
        public EntityBuilder<T> shouldVisualize(VisualizationPredicate<T> predicate) {
            this.predicate = predicate;
            return this;
        }

        /**
         * Add a configured visual element to this visualizer.
         *
         * @param element The configured visual element.
         */
        public EntityBuilder<T> with(ConfiguredElement<? super T> element) {
            elements.add(element);
            return this;
        }

        public EntityBuilder<T> apply(Consumer<EntityBuilder<T>> mutate) {
            mutate.accept(this);
            return this;
        }

        public EntityVisualizerBuilder<T> build() {
            var elementsArray = elements.toArray(new ConfiguredElement[0]);

            if (predicate == null) {
                predicate = VisualizationPredicate.alwaysTrue();
            }

            var controller = new ComposableEntityVisual.Controller<T>(elementsArray, predicate);

            return builder(entityType).factory((ctx, entity, partialTick) -> new ComposableEntityVisual<T>(ctx, entity, partialTick, controller));
        }
    }

    public static <T extends class_2586> BlockEntityVisualizerBuilder<T> builder(class_2591<T> type) {
        return new BlockEntityVisualizerBuilder<>(CONFIGURATOR, type);
    }

    public static <T extends class_1297> EntityVisualizerBuilder<T> builder(class_1299<T> type) {
        return new EntityVisualizerBuilder<>(CONFIGURATOR, type);
    }
}
