package com.zurrtum.create.client.vanillin.visuals;

import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.material.Material;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.material.SimpleMaterial;
import com.zurrtum.create.client.flywheel.lib.model.part.InstanceTree;
import com.zurrtum.create.client.flywheel.lib.model.part.ModelTrees;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractBlockEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

import java.util.function.Consumer;
import net.minecraft.class_2338;
import net.minecraft.class_3532;
import net.minecraft.class_3721;
import net.minecraft.class_3880;
import net.minecraft.class_5602;

public class BellVisual extends AbstractBlockEntityVisual<class_3721> implements SimpleDynamicVisual {
    private static final Material MATERIAL = SimpleMaterial.builder().mipmap(false).build();

    private final InstanceTree instances;
    private final InstanceTree bellBody;

    private final Matrix4fc initialPose;

    private boolean wasShaking = false;

    public BellVisual(VisualizationContext ctx, class_3721 blockEntity, float partialTick) {
        super(ctx, blockEntity, partialTick);

        instances = InstanceTree.create(
            instancerProvider(),
            ModelTrees.of(class_5602.field_27683, class_3880.field_17145, MATERIAL)
        );
        bellBody = instances.childOrThrow("bell_body");

        class_2338 visualPos = getVisualPosition();
        initialPose = new Matrix4f().translate(visualPos.method_10263(), visualPos.method_10264(), visualPos.method_10260());

        updateRotation(partialTick);
    }

    @Override
    public void beginFrame(Context context) {
        if (doDistanceLimitThisFrame(context) || !isVisible(context.frustum())) {
            return;
        }

        updateRotation(context.partialTick());
    }

    private void updateRotation(float partialTick) {
        float xRot = 0;
        float zRot = 0;

        if (blockEntity.field_17096) {
            float ringTime = (float) blockEntity.field_17095 + partialTick;
            float angle = class_3532.method_15374(ringTime / (float) Math.PI) / (4.0F + ringTime / 3.0F);

            switch (blockEntity.field_17097) {
                case field_11043 -> xRot = -angle;
                case field_11035 -> xRot = angle;
                case field_11034 -> zRot = -angle;
                case field_11039 -> zRot = angle;
            }

            wasShaking = true;
        } else if (wasShaking) {
            wasShaking = false;
        }

        bellBody.xRot(xRot);
        bellBody.zRot(zRot);
        instances.updateInstancesStatic(initialPose);
    }

    @Override
    public void updateLight(float partialTick) {
        int packedLight = computePackedLight();
        instances.traverse(instance -> {
            instance.light(packedLight).setChanged();
        });
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        instances.traverse(consumer);
    }

    @Override
    protected void _delete() {
        instances.delete();
    }
}
