package com.zurrtum.create.compat.computercraft.implementation.luaObjects;

import com.zurrtum.create.compat.computercraft.implementation.ComputerUtil;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.packager.PackagerBlockEntity;
import com.zurrtum.create.infrastructure.items.ItemStackHandler;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;

public class PackageLuaObject implements LuaComparable {
    public final PackagerBlockEntity blockEntity;
    public final class_1799 box;
    public String address;
    // address is the only mutable data of the package.
    // we update this along with .setAddress().
    // if the package changes address for any other reason, we don't know that.

    public PackageLuaObject(PackagerBlockEntity blockEntity, class_1799 box) {
        this.blockEntity = blockEntity;
        this.box = box;
        this.address = PackageItem.getAddress(box);
    }

    @LuaFunction(mainThread = true)
    public final boolean isEditable() {
        return (blockEntity != null && !blockEntity.heldBox.method_7960() && blockEntity.heldBox == box);
    }

    @LuaFunction(mainThread = true)
    public final String getAddress() throws LuaException {
        if (isEditable())
            this.address = PackageItem.getAddress(box);
        return this.address;
    }

    @LuaFunction(mainThread = true)
    public final void setAddress(String argument) throws LuaException {
        if (!isEditable())
            throw new LuaException("Package is not editable");
        PackageItem.addAddress(box, argument);
        this.address = argument;
    }

    @LuaFunction(mainThread = true)
    public Map<Integer, Map<String, ?>> list() {
        return ComputerUtil.list(PackageItem.getContents(box));
    }

    @LuaFunction(mainThread = true)
    public Map<String, ?> getItemDetail(int slot) throws LuaException {
        return ComputerUtil.getItemDetail(PackageItem.getContents(box), slot);
    }

    public boolean hasOrderData() {
        return PackageItem.hasOrderData(box);
    }

    @LuaFunction(mainThread = true)
    public final PackageOrderLuaObject getOrderData() throws LuaException {

        if (!hasOrderData())
            return null;

        return new PackageOrderLuaObject(this);
    }

    public final List<LuaItemStack> getLuaItemStacks() {
        ItemStackHandler results = PackageItem.getContents(box);
        List<LuaItemStack> result = new ArrayList<>();

        for (int i = 0; i < results.method_5439(); i++) {
            class_1799 stack = results.method_5438(i);
            if (!stack.method_7960()) {
                result.add(new LuaItemStack(stack));
            }
        }

        return result;
    }

    @Override
    public Map<?, ?> getTableRepresentation() {
        try {
            Map<String, Object> map = new HashMap<>();
            map.put("address", getAddress());
            // Lazy getter so we don't need to get the contents if we don't need to
            map.put("contents", getLuaItemStacks());

            if (hasOrderData())
                map.put("orderData", getOrderData());
            return map;

        } catch (LuaException e) {
            return null; // Should never happen
        }
    }
}
