package com.zurrtum.create.compat.computercraft.implementation.peripherals;

import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlockEntity;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkContext;
import com.zurrtum.create.content.redstone.displayLink.target.DisplayTargetStats;
import dan200.computercraft.api.lua.*;
import org.jetbrains.annotations.NotNull;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_2499;
import net.minecraft.class_2519;

public class DisplayLinkPeripheral extends SyncedPeripheral<DisplayLinkBlockEntity> {

    public static final String TAG_KEY = "ComputerSourceList";
    private final AtomicInteger cursorX = new AtomicInteger();
    private final AtomicInteger cursorY = new AtomicInteger();

    public DisplayLinkPeripheral(DisplayLinkBlockEntity blockEntity) {
        super(blockEntity);
    }

    @LuaFunction
    public final void setCursorPos(int x, int y) {
        cursorX.set(x - 1);
        cursorY.set(y - 1);
    }

    @LuaFunction
    public final Object[] getCursorPos() {
        return new Object[]{cursorX.get() + 1, cursorY.get() + 1};
    }

    @LuaFunction(mainThread = true)
    public final Object[] getSize() {
        blockEntity.updateGatheredData();
        DisplayTargetStats stats = blockEntity.activeTarget.provideStats(new DisplayLinkContext(blockEntity.method_10997(), blockEntity));
        return new Object[]{stats.maxRows(), stats.maxColumns()};
    }

    @LuaFunction
    public final boolean isColor() {
        return false;
    }

    @LuaFunction
    public final boolean isColour() {
        return false;
    }

    @LuaFunction
    public final void write(String text) {
        writeImpl(text);
    }

    @LuaFunction
    public final void writeBytes(IArguments args) throws LuaException {
        Object data = args.get(0);
        byte[] bytes;
        if (data instanceof String str) {
            bytes = str.getBytes(StandardCharsets.US_ASCII);
        } else if (data instanceof Map<?, ?> map) {
            ObjectLuaTable table = new ObjectLuaTable(map);
            bytes = new byte[table.length()];
            for (int i = 0; i < bytes.length; i++) {
                bytes[i] = (byte) (table.getInt(i + 1) & 0xff);
            }
        } else {
            throw LuaValues.badArgumentOf(args, 0, "string or table");
        }
        writeImpl(new String(bytes, StandardCharsets.UTF_8));
    }

    protected final void writeImpl(String text) {
        class_2499 tag = blockEntity.getSourceConfig().method_10554(TAG_KEY).orElse(new class_2499());

        int x = cursorX.get();
        int y = cursorY.get();

        for (int i = tag.size(); i <= y; i++) {
            tag.add(class_2519.method_23256(""));
        }

        StringBuilder builder = new StringBuilder(tag.method_68577(y, ""));

        builder.append(" ".repeat(Math.max(0, x - builder.length())));
        builder.replace(x, x + text.length(), text);

        tag.method_68585(y, class_2519.method_23256(builder.toString()));

        synchronized (blockEntity) {
            blockEntity.getSourceConfig().method_10566(TAG_KEY, tag);
        }

        cursorX.set(x + text.length());
    }

    @LuaFunction
    public final void clearLine() {
        class_2499 tag = blockEntity.getSourceConfig().method_10554(TAG_KEY).orElse(new class_2499());

        if (tag.size() > cursorY.get())
            tag.method_68585(cursorY.get(), class_2519.method_23256(""));

        synchronized (blockEntity) {
            blockEntity.getSourceConfig().method_10566(TAG_KEY, tag);
        }
    }

    @LuaFunction
    public final void clear() {
        synchronized (blockEntity) {
            blockEntity.getSourceConfig().method_10566(TAG_KEY, new class_2499());
        }
    }

    @LuaFunction(mainThread = true)
    public final void update() {
        blockEntity.tickSource();
    }

    @NotNull
    @Override
    public String getType() {
        return "Create_DisplayLink";
    }

}
