package com.zurrtum.create.compat.computercraft.implementation.peripherals;

import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.compat.computercraft.events.ComputerEvent;
import com.zurrtum.create.compat.computercraft.events.SignalStateChangeEvent;
import com.zurrtum.create.compat.computercraft.implementation.CreateLuaTable;
import com.zurrtum.create.content.trains.entity.Train;
import com.zurrtum.create.content.trains.signal.SignalBlock;
import com.zurrtum.create.content.trains.signal.SignalBlockEntity;
import com.zurrtum.create.content.trains.signal.SignalBoundary;
import com.zurrtum.create.content.trains.signal.SignalEdgeGroup;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import org.jetbrains.annotations.NotNull;

import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

public class SignalPeripheral extends SyncedPeripheral<SignalBlockEntity> {

    public SignalPeripheral(SignalBlockEntity blockEntity) {
        super(blockEntity);
    }

    @LuaFunction
    public final String getState() {
        return blockEntity.getState().toString();
    }

    @LuaFunction
    public final boolean isForcedRed() {
        return blockEntity.method_11010().method_11654(SignalBlock.POWERED);
    }

    @LuaFunction(mainThread = true)
    public final void setForcedRed(boolean powered) {
        class_1937 level = blockEntity.method_10997();
        if (level != null)
            level.method_8652(blockEntity.method_11016(), blockEntity.method_11010().method_11657(SignalBlock.POWERED, powered), 2);
    }

    @LuaFunction
    public final CreateLuaTable listBlockingTrainNames() throws LuaException {
        SignalBoundary signal = blockEntity.getSignal();
        if (signal == null)
            throw new LuaException("no signal");
        CreateLuaTable trainList = new CreateLuaTable();
        int trainCounter = 1;
        for (boolean current : Iterate.trueAndFalse) {
            Map<class_2338, Boolean> set = signal.blockEntities.get(current);
            if (!set.containsKey(blockEntity.method_11016()))
                continue;
            UUID group = signal.groups.get(current);
            Map<UUID, SignalEdgeGroup> signalEdgeGroups = Create.RAILWAYS.signalEdgeGroups;
            SignalEdgeGroup signalEdgeGroup = signalEdgeGroups.get(group);
            for (Train train : signalEdgeGroup.trains) {
                trainList.put(trainCounter, train.name.getString());
                trainCounter += 1;
            }
        }
        return trainList;
    }

    @LuaFunction
    public final String getSignalType() throws LuaException {
        SignalBoundary signal = blockEntity.getSignal();
        if (signal != null) {
            return signal.getTypeFor(blockEntity.method_11016()).toString();
        } else {
            throw new LuaException("no signal");
        }
    }

    @LuaFunction(mainThread = true)
    public final void cycleSignalType() throws LuaException {
        SignalBoundary signal = blockEntity.getSignal();
        if (signal != null) {
            signal.cycleSignalType(blockEntity.method_11016());
        } else {
            throw new LuaException("no signal");
        }
    }

    @Override
    public void prepareComputerEvent(@NotNull ComputerEvent event) {
        if (event instanceof SignalStateChangeEvent ssce) {
            queueEvent("train_signal_state_change", ssce.state.toString());
        }
    }

    @NotNull
    @Override
    public String getType() {
        return "Create_Signal";
    }

}
