package com.zurrtum.create.compat.computercraft.implementation.peripherals;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.content.contraptions.chassis.StickerBlock;
import com.zurrtum.create.content.contraptions.chassis.StickerBlockEntity;
import dan200.computercraft.api.lua.LuaFunction;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;

public class StickerPeripheral extends SyncedPeripheral<StickerBlockEntity> {

    public StickerPeripheral(StickerBlockEntity blockEntity) {
        super(blockEntity);
    }

    @LuaFunction
    public boolean isExtended() {
        return blockEntity.isBlockStateExtended();
    }

    @LuaFunction
    public boolean isAttachedToBlock() {
        return blockEntity.isBlockStateExtended() && blockEntity.isAttachedToBlock();
    }

    @LuaFunction(mainThread = true)
    public boolean extend() {
        class_2680 state = blockEntity.method_11010();
        if (!state.method_27852(AllBlocks.STICKER) || state.method_11654(StickerBlock.EXTENDED))
            return false;
        blockEntity.method_10997().method_8652(blockEntity.method_11016(), state.method_11657(StickerBlock.EXTENDED, true), class_2248.field_31028);
        return true;
    }

    @LuaFunction(mainThread = true)
    public boolean retract() {
        class_2680 state = blockEntity.method_11010();
        if (!state.method_27852(AllBlocks.STICKER) || !state.method_11654(StickerBlock.EXTENDED))
            return false;
        blockEntity.method_10997().method_8652(blockEntity.method_11016(), state.method_11657(StickerBlock.EXTENDED, false), class_2248.field_31028);
        return true;
    }

    @LuaFunction(mainThread = true)
    public boolean toggle() {
        class_2680 state = blockEntity.method_11010();
        if (!state.method_27852(AllBlocks.STICKER))
            return false;
        boolean extended = state.method_11654(StickerBlock.EXTENDED);
        blockEntity.method_10997().method_8652(blockEntity.method_11016(), state.method_11657(StickerBlock.EXTENDED, !extended), class_2248.field_31028);
        return true;
    }

    @NotNull
    @Override
    public String getType() {
        return "Create_Sticker";
    }

}
