package com.zurrtum.create.compat.rei.display;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.compat.rei.ReiCommonPlugin;
import com.zurrtum.create.content.kinetics.press.MechanicalPressBlockEntity;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.client.displays.ClientsidedCraftingDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCraftingDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomShapelessDisplay;
import net.minecraft.class_10295;
import net.minecraft.class_10298;
import net.minecraft.class_10301;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_2960;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.Optional;

public interface AutoMixingDisplay {
    @SuppressWarnings("unchecked")
    static Display of(class_8786<?> entry) {
        class_1860<?> recipe = entry.comp_1933();
        if (MechanicalPressBlockEntity.canCompress(recipe) || AllRecipeTypes.shouldIgnoreInAutomation(entry)) {
            return null;
        }
        if (recipe instanceof class_1867 shapelessRecipe) {
            if (shapelessRecipe.field_9047.size() > 1) {
                return new ShapelessDisplay((class_8786<class_1867>) entry);
            }
        } else if (!recipe.method_8118()) {
            for (class_10295 d : recipe.method_64664()) {
                if (d instanceof class_10301 display && display.comp_3271().size() > 1) {
                    return new CraftingDisplayShapeless(display);
                }
            }
        }
        return null;
    }

    @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
    class ShapelessDisplay extends DefaultCustomShapelessDisplay implements AutoMixingDisplay {
        public static final DisplaySerializer<ShapelessDisplay> SERIALIZER = DisplaySerializer.of(
            RecordCodecBuilder.mapCodec(instance -> instance.group(
                EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(DefaultCraftingDisplay::getInputEntries),
                EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(DefaultCraftingDisplay::getOutputEntries),
                class_2960.field_25139.optionalFieldOf("location").forGetter(DefaultCraftingDisplay::getDisplayLocation)
            ).apply(instance, ShapelessDisplay::new)), class_9139.method_56436(
                EntryIngredient.streamCodec().method_56433(class_9135.method_56363()),
                DefaultCraftingDisplay::getInputEntries,
                EntryIngredient.streamCodec().method_56433(class_9135.method_56363()),
                DefaultCraftingDisplay::getOutputEntries,
                class_9135.method_56382(class_2960.field_48267),
                DefaultCraftingDisplay::getDisplayLocation,
                ShapelessDisplay::new
            )
        );

        public ShapelessDisplay(List<EntryIngredient> input, List<EntryIngredient> output, Optional<class_2960> location) {
            super(input, output, location);
        }

        public ShapelessDisplay(class_8786<class_1867> recipe) {
            super(
                CollectionUtils.map(recipe.comp_1933().method_61671().method_64675(), EntryIngredients::ofIngredient),
                List.of(EntryIngredients.of(recipe.comp_1933().field_9050)),
                Optional.of(recipe.comp_1932().method_29177())
            );
        }

        @Override
        public List<InputIngredient<EntryStack<?>>> getInputIngredients(@Nullable class_1703 menu, @Nullable class_1657 player) {
            return CollectionUtils.mapIndexed(getInputEntries(), InputIngredient::of);
        }

        @Override
        public CategoryIdentifier<?> getCategoryIdentifier() {
            return ReiCommonPlugin.AUTOMATIC_SHAPELESS;
        }

        @Override
        public DisplaySerializer<? extends Display> getSerializer() {
            return SERIALIZER;
        }
    }

    @SuppressWarnings("OptionalUsedAsFieldOrParameterType")
    class CraftingDisplayShapeless extends ClientsidedCraftingDisplay.Shapeless implements AutoMixingDisplay {
        public static final DisplaySerializer<CraftingDisplayShapeless> SERIALIZER = DisplaySerializer.of(
            RecordCodecBuilder.mapCodec(instance -> instance.group(
                EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(Shapeless::getInputEntries),
                EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(Shapeless::getOutputEntries),
                Codec.INT.xmap(class_10298::new, class_10298::comp_3267).optionalFieldOf("id").forGetter(Shapeless::recipeDisplayId)
            ).apply(instance, CraftingDisplayShapeless::new)), class_9139.method_56436(
                EntryIngredient.streamCodec().method_56433(class_9135.method_56363()),
                Shapeless::getInputEntries,
                EntryIngredient.streamCodec().method_56433(class_9135.method_56363()),
                Shapeless::getOutputEntries,
                class_9135.method_56382(class_9135.field_49675.method_56432(class_10298::new, class_10298::comp_3267)),
                Shapeless::recipeDisplayId,
                CraftingDisplayShapeless::new
            ), false
        );

        public CraftingDisplayShapeless(class_10301 recipe) {
            super(recipe, Optional.empty());
        }

        public CraftingDisplayShapeless(List<EntryIngredient> inputs, List<EntryIngredient> outputs, Optional<class_10298> id) {
            super(inputs, outputs, id);
        }

        @Override
        public List<InputIngredient<EntryStack<?>>> getInputIngredients(@Nullable class_1703 menu, @Nullable class_1657 player) {
            return CollectionUtils.mapIndexed(getInputEntries(), InputIngredient::of);
        }

        @Override
        public CategoryIdentifier<?> getCategoryIdentifier() {
            return ReiCommonPlugin.AUTOMATIC_SHAPELESS;
        }

        @Override
        public DisplaySerializer<? extends Display> getSerializer() {
            return SERIALIZER;
        }
    }
}
