package com.zurrtum.create.compat.rei.display;

import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllRecipeTypes;
import com.zurrtum.create.Create;
import com.zurrtum.create.catnip.data.Pair;
import com.zurrtum.create.compat.rei.ReiCommonPlugin;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.registry.display.ServerDisplayRegistry;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_3975;
import net.minecraft.class_6885;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.*;

import static com.zurrtum.create.Create.MOD_ID;

public record BlockCuttingDisplay(EntryIngredient input, List<EntryIngredient> outputs, Optional<class_2960> location) implements Display {
    public static final DisplaySerializer<BlockCuttingDisplay> SERIALIZER = DisplaySerializer.of(
        RecordCodecBuilder.mapCodec(instance -> instance.group(
            EntryIngredient.codec().fieldOf("input").forGetter(BlockCuttingDisplay::input),
            EntryIngredient.codec().listOf().fieldOf("outputs").forGetter(BlockCuttingDisplay::outputs),
            class_2960.field_25139.optionalFieldOf("location").forGetter(BlockCuttingDisplay::location)
        ).apply(instance, BlockCuttingDisplay::new)), class_9139.method_56436(
            EntryIngredient.streamCodec(),
            BlockCuttingDisplay::input,
            EntryIngredient.streamCodec().method_56433(class_9135.method_56363()),
            BlockCuttingDisplay::outputs,
            class_9135.method_56382(class_2960.field_48267),
            BlockCuttingDisplay::location,
            BlockCuttingDisplay::new
        )
    );

    public static void register(ServerDisplayRegistry registry) {
        Object2ObjectMap<class_1856, Pair<EntryIngredient, List<class_1799>>> map = new Object2ObjectOpenCustomHashMap<>(new Hash.Strategy<>() {
            public boolean equals(class_1856 ingredient, class_1856 other) {
                return Objects.equals(ingredient, other);
            }

            public int hashCode(class_1856 ingredient) {
                if (ingredient.field_9019 instanceof class_6885.class_6886<class_1792> direct) {
                    return direct.hashCode();
                }
                if (ingredient.field_9019 instanceof class_6885.class_6888<class_1792> named) {
                    return named.method_40251().comp_327().hashCode();
                }
                return ingredient.hashCode();
            }
        });
        for (class_8786<class_3975> entry : Create.SERVER.method_3772().field_54638.method_64698(class_3956.field_17641)) {
            if (AllRecipeTypes.shouldIgnoreInAutomation(entry)) {
                continue;
            }
            class_3975 recipe = entry.comp_1933();
            Pair<EntryIngredient, List<class_1799>> display = map.computeIfAbsent(
                recipe.method_64720(),
                ingredient -> Pair.of(EntryIngredients.ofIngredient((class_1856) ingredient), new ArrayList<>())
            );
            display.getSecond().add(recipe.method_64721());
        }
        for (Pair<EntryIngredient, List<class_1799>> pair : map.values()) {
            EntryIngredient input = pair.getFirst();
            List<class_1799> outputs = pair.getSecond();
            class_2960 itemName = class_7923.field_41178.method_10221(input.getFirst().<class_1799>castValue().method_7909());
            Optional<class_2960> location = Optional.of(class_2960.method_60655(MOD_ID, "block_cutting/" + itemName.method_12836() + "_" + itemName.method_12832()));
            int size = outputs.size();
            if (size <= 15) {
                List<EntryIngredient> outputIngredients = Arrays.asList(new EntryIngredient[size]);
                for (int i = 0; i < size; i++) {
                    outputIngredients.set(i, EntryIngredients.of(outputs.get(i)));
                }
                registry.add(new BlockCuttingDisplay(input, outputIngredients, location));
            } else {
                EntryIngredient.Builder[] builders = new EntryIngredient.Builder[15];
                for (int i = 0; i < 15; i++) {
                    builders[i] = EntryIngredient.builder().add(EntryStacks.of(outputs.get(i)));
                }
                for (int i = 15; i < size; i++) {
                    builders[i % 15].add(EntryStacks.of(outputs.get(i)));
                }
                List<EntryIngredient> outputIngredients = Arrays.asList(new EntryIngredient[15]);
                for (int i = 0; i < 15; i++) {
                    outputIngredients.set(i, builders[i].build());
                }
                registry.add(new BlockCuttingDisplay(input, outputIngredients, location));
            }
        }
    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        return List.of(input);
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        return outputs;
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return ReiCommonPlugin.BLOCK_CUTTING;
    }

    @Override
    public Optional<class_2960> getDisplayLocation() {
        return location;
    }

    @Override
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
}
