package com.zurrtum.create.compat.rei.display;

import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.compat.rei.ReiCommonPlugin;
import com.zurrtum.create.content.kinetics.mixer.MixingRecipe;
import com.zurrtum.create.content.processing.recipe.HeatCondition;
import dev.architectury.fluid.FluidStack;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_2960;
import net.minecraft.class_8786;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import java.util.List;
import java.util.Optional;

import static com.zurrtum.create.compat.rei.IngredientHelper.*;

public record MixingDisplay(
    List<EntryIngredient> inputs, EntryIngredient output, HeatCondition heat, Optional<class_2960> location
) implements Display {
    public static final DisplaySerializer<MixingDisplay> SERIALIZER = DisplaySerializer.of(
        RecordCodecBuilder.mapCodec(instance -> instance.group(
            EntryIngredient.codec().listOf().fieldOf("inputs").forGetter(MixingDisplay::inputs),
            EntryIngredient.codec().fieldOf("output").forGetter(MixingDisplay::output),
            HeatCondition.CODEC.fieldOf("heat").forGetter(MixingDisplay::heat),
            class_2960.field_25139.optionalFieldOf("location").forGetter(MixingDisplay::location)
        ).apply(instance, MixingDisplay::new)), class_9139.method_56905(
            EntryIngredient.streamCodec().method_56433(class_9135.method_56363()),
            MixingDisplay::inputs,
            EntryIngredient.streamCodec(),
            MixingDisplay::output,
            HeatCondition.PACKET_CODEC,
            MixingDisplay::heat,
            class_9135.method_56382(class_2960.field_48267),
            MixingDisplay::location,
            MixingDisplay::new
        )
    );

    public MixingDisplay(class_8786<MixingRecipe> entry) {
        this(entry.comp_1932().method_29177(), entry.comp_1933());
    }

    public MixingDisplay(class_2960 id, MixingRecipe recipe) {
        this(
            getEntryIngredients(getSizedIngredientStream(recipe.ingredients()), getFluidIngredientStream(recipe.fluidIngredients())),
            recipe.result().method_7960() ? EntryIngredients.of(FluidStack.create(
                recipe.fluidResult().getFluid(),
                recipe.fluidResult().getAmount()
            )) : EntryIngredients.of(recipe.result()),
            recipe.heat(),
            Optional.of(id)
        );
    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        return inputs;
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        return List.of(output);
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return ReiCommonPlugin.MIXING;
    }

    @Override
    public Optional<class_2960> getDisplayLocation() {
        return location;
    }

    @Override
    public DisplaySerializer<? extends Display> getSerializer() {
        return SERIALIZER;
    }
}
