package com.zurrtum.create.content.contraptions;

import com.zurrtum.create.AllEntityTypes;
import com.zurrtum.create.api.behaviour.movement.MovementBehaviour;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.content.contraptions.bearing.BearingContraption;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_3499.class_3501;

/**
 * Ex: Pistons, bearings <br>
 * Controlled Contraption Entities can rotate around one axis and translate.
 * <br>
 * They are bound to an {@link IControlContraption}
 */
public class ControlledContraptionEntity extends AbstractContraptionEntity {

    protected class_2338 controllerPos;
    protected class_2351 rotationAxis;
    public float prevAngle;
    public float angle;
    protected float angleDelta;

    public ControlledContraptionEntity(class_1299<? extends ControlledContraptionEntity> type, class_1937 world) {
        super(type, world);
    }

    public static ControlledContraptionEntity create(class_1937 world, IControlContraption controller, Contraption contraption) {
        ControlledContraptionEntity entity = new ControlledContraptionEntity(AllEntityTypes.CONTROLLED_CONTRAPTION, world);
        entity.controllerPos = controller.getBlockPosition();
        entity.setContraption(contraption);
        return entity;
    }

    @Override
    public void method_5814(double x, double y, double z) {
        super.method_5814(x, y, z);
        if (!method_73183().method_8608())
            return;
        for (class_1297 entity : method_5685())
            method_24201(entity);
    }

    @Override
    public class_243 getContactPointMotion(class_243 globalContactPoint) {
        if (contraption instanceof TranslatingContraption)
            return method_18798();
        return super.getContactPointMotion(globalContactPoint);
    }

    @Override
    protected void setContraption(Contraption contraption) {
        super.setContraption(contraption);
        if (contraption instanceof BearingContraption)
            rotationAxis = ((BearingContraption) contraption).getFacing().method_10166();
    }

    @Override
    protected void readAdditional(class_11368 view, boolean spawnPacket) {
        super.readAdditional(view, spawnPacket);
        view.method_71426("ControllerRelative", class_2338.field_25064).ifPresent(pos -> controllerPos = pos.method_10081(method_24515()));
        view.method_71426("Axis", class_2351.field_25065).ifPresent(axis -> rotationAxis = axis);
        angle = view.method_71423("Angle", 0);
    }

    @Override
    protected void writeAdditional(class_11372 view, boolean spawnPacket) {
        super.writeAdditional(view, spawnPacket);
        view.method_71468("ControllerRelative", class_2338.field_25064, controllerPos.method_10059(method_24515()));
        if (rotationAxis != null)
            view.method_71468("Axis", class_2351.field_25065, rotationAxis);
        view.method_71464("Angle", angle);
    }

    @Override
    public ContraptionRotationState getRotationState() {
        ContraptionRotationState crs = new ContraptionRotationState();
        if (rotationAxis == class_2351.field_11048)
            crs.xRotation = angle;
        if (rotationAxis == class_2351.field_11052)
            crs.yRotation = angle;
        if (rotationAxis == class_2351.field_11051)
            crs.zRotation = angle;
        return crs;
    }

    @Override
    public class_243 applyRotation(class_243 localPos, float partialTicks) {
        localPos = VecHelper.rotate(localPos, getAngle(partialTicks), rotationAxis);
        return localPos;
    }

    @Override
    public class_243 reverseRotation(class_243 localPos, float partialTicks) {
        localPos = VecHelper.rotate(localPos, -getAngle(partialTicks), rotationAxis);
        return localPos;
    }

    public void setAngle(float angle) {
        this.angle = angle;

        if (!method_73183().method_8608())
            return;
        for (class_1297 entity : method_5685())
            method_24201(entity);
    }

    public float getAngle(float partialTicks) {
        return partialTicks == 1.0F ? angle : AngleHelper.angleLerp(partialTicks, prevAngle, angle);
    }

    public void setRotationAxis(class_2351 rotationAxis) {
        this.rotationAxis = rotationAxis;
    }

    public class_2351 getRotationAxis() {
        return rotationAxis;
    }

    @Override
    public void method_5859(double p_70634_1_, double p_70634_3_, double p_70634_5_) {
    }

    // Always noop this. Controlled Contraptions are given their position on the client from the BE
    @Override
    public void method_66246(class_243 pos, float yaw, float pitch) {
    }

    protected void tickContraption() {
        angleDelta = angle - prevAngle;
        prevAngle = angle;
        tickActors();

        if (controllerPos == null)
            return;
        if (!method_73183().method_8477(controllerPos))
            return;
        IControlContraption controller = getController();
        if (controller == null) {
            method_31472();
            return;
        }
        if (!controller.isAttachedTo(this)) {
            controller.attach(this);
            if (method_73183().method_8608())
                method_5814(method_23317(), method_23318(), method_23321());
        }
    }

    @Override
    protected boolean shouldActorTrigger(
        MovementContext context,
        class_3501 blockInfo,
        MovementBehaviour actor,
        class_243 actorPosition,
        class_2338 gridPosition
    ) {
        if (super.shouldActorTrigger(context, blockInfo, actor, actorPosition, gridPosition))
            return true;

        // Special activation timer for actors in the center of a bearing contraption
        if (!(contraption instanceof BearingContraption bc))
            return false;
        class_2350 facing = bc.getFacing();
        class_243 activeAreaOffset = actor.getActiveAreaOffset(context);
        if (!activeAreaOffset.method_18806(VecHelper.axisAlingedPlaneOf(class_243.method_24954(facing.method_62675()))).equals(class_243.field_1353))
            return false;
        if (!VecHelper.onSameAxis(blockInfo.comp_1341(), class_2338.field_10980, facing.method_10166()))
            return false;
        context.motion = class_243.method_24954(facing.method_62675()).method_1021(angleDelta / 360.0);
        context.relativeMotion = context.motion;
        int timer = context.data.method_68083("StationaryTimer", 0);
        if (timer > 0) {
            context.data.method_10569("StationaryTimer", timer - 1);
            return false;
        }

        context.data.method_10569("StationaryTimer", 20);
        return true;
    }

    protected IControlContraption getController() {
        if (controllerPos == null)
            return null;
        if (!method_73183().method_8477(controllerPos))
            return null;
        class_2586 be = method_73183().method_8321(controllerPos);
        if (!(be instanceof IControlContraption))
            return null;
        return (IControlContraption) be;
    }

    @Override
    protected StructureTransform makeStructureTransform() {
        class_2338 offset = class_2338.method_49638(getAnchorVec().method_1031(.5, .5, .5));
        float xRot = rotationAxis == class_2351.field_11048 ? angle : 0;
        float yRot = rotationAxis == class_2351.field_11052 ? angle : 0;
        float zRot = rotationAxis == class_2351.field_11051 ? angle : 0;
        return new StructureTransform(offset, xRot, yRot, zRot);
    }

    @Override
    protected void onContraptionStalled() {
        IControlContraption controller = getController();
        if (controller != null)
            controller.onStall();
        super.onContraptionStalled();
    }

    @Override
    protected float getStalledAngle() {
        return angle;
    }

    @Override
    public void handleStallInformation(double x, double y, double z, float angle) {
        method_23327(x, y, z);
        this.angle = this.prevAngle = angle;
    }
}
