package com.zurrtum.create.content.contraptions.actors.trainControls;

import com.zurrtum.create.catnip.data.IntAttached;
import com.zurrtum.create.catnip.data.WorldAttached;
import com.zurrtum.create.content.contraptions.AbstractContraptionEntity;
import java.util.*;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_2338;

public class ControlsServerHandler {

    public static WorldAttached<Map<UUID, ControlsContext>> receivedInputs = new WorldAttached<>($ -> new HashMap<>());
    static final int TIMEOUT = 30;

    public static void tick(class_1936 world) {
        Map<UUID, ControlsContext> map = receivedInputs.get(world);
        for (Iterator<Map.Entry<UUID, ControlsContext>> iterator = map.entrySet().iterator(); iterator.hasNext(); ) {

            Map.Entry<UUID, ControlsContext> entry = iterator.next();
            ControlsContext ctx = entry.getValue();
            Collection<ManuallyPressedKey> list = ctx.keys;

            if (ctx.entity.method_31481()) {
                iterator.remove();
                continue;
            }

            for (Iterator<ManuallyPressedKey> entryIterator = list.iterator(); entryIterator.hasNext(); ) {
                ManuallyPressedKey pressedKey = entryIterator.next();
                pressedKey.decrement();
                if (!pressedKey.isAlive())
                    entryIterator.remove(); // key released
            }

            class_1657 player = world.method_18470(entry.getKey());
            if (player == null) {
                ctx.entity.stopControlling(ctx.controlsLocalPos);
                iterator.remove();
                continue;
            }

            if (!ctx.entity.control(ctx.controlsLocalPos, list.stream().map(ManuallyPressedKey::getSecond).toList(), player)) {
                ctx.entity.stopControlling(ctx.controlsLocalPos);
            }

            if (list.isEmpty())
                iterator.remove();
        }
    }

    public static void receivePressed(
        class_1936 world,
        AbstractContraptionEntity entity,
        class_2338 controlsPos,
        UUID uniqueID,
        Collection<Integer> collect,
        boolean pressed
    ) {
        Map<UUID, ControlsContext> map = receivedInputs.get(world);

        if (map.containsKey(uniqueID) && map.get(uniqueID).entity != entity)
            map.remove(uniqueID);

        ControlsContext ctx = map.computeIfAbsent(uniqueID, $ -> new ControlsContext(entity, controlsPos));
        Collection<ManuallyPressedKey> list = ctx.keys;

        WithNext:
        for (Integer activated : collect) {
            for (ManuallyPressedKey entry : list) {
                Integer inputType = entry.getSecond();
                if (inputType.equals(activated)) {
                    if (!pressed)
                        entry.setFirst(0);
                    else
                        entry.keepAlive();
                    continue WithNext;
                }
            }

            if (!pressed)
                continue;

            list.add(new ManuallyPressedKey(activated)); // key newly pressed
        }
    }

    public static class ControlsContext {

        Collection<ManuallyPressedKey> keys;
        AbstractContraptionEntity entity;
        class_2338 controlsLocalPos;

        public ControlsContext(AbstractContraptionEntity entity, class_2338 controlsPos) {
            this.entity = entity;
            controlsLocalPos = controlsPos;
            keys = new ArrayList<>();
        }

    }

    static class ManuallyPressedKey extends IntAttached<Integer> {

        public ManuallyPressedKey(Integer second) {
            super(TIMEOUT, second);
        }

        public void keepAlive() {
            setFirst(TIMEOUT);
        }

        public boolean isAlive() {
            return getFirst() > 0;
        }

    }

}
