package com.zurrtum.create.content.contraptions.chassis;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.api.contraption.BlockMovementChecks;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerChassisScrollValueBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.scrollValue.ServerScrollValueBehaviour;
import com.zurrtum.create.infrastructure.config.AllConfigs;
import java.util.*;
import net.minecraft.class_11368;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;

public class ChassisBlockEntity extends SmartBlockEntity {

    ServerScrollValueBehaviour range;

    public int currentlySelectedRange;

    public ChassisBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.CHASSIS, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        int max = AllConfigs.server().kinetics.maxChassisRange.get();
        range = new ServerChassisScrollValueBehaviour(this, be -> ((ChassisBlockEntity) be).collectChassisGroup());
        range.between(1, max);
        range.setValue(max / 2);
        behaviours.add(range);
        currentlySelectedRange = range.getValue();
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        if (clientPacket)
            currentlySelectedRange = getRange();
    }

    public int getRange() {
        return range.getValue();
    }

    public List<class_2338> getIncludedBlockPositions(class_2350 forcedMovement, boolean visualize) {
        if (!(method_11010().method_26204() instanceof AbstractChassisBlock))
            return Collections.emptyList();
        return isRadial() ? getIncludedBlockPositionsRadial(forcedMovement, visualize) : getIncludedBlockPositionsLinear(forcedMovement, visualize);
    }

    protected boolean isRadial() {
        return field_11863.method_8320(field_11867).method_26204() instanceof RadialChassisBlock;
    }

    public List<ChassisBlockEntity> collectChassisGroup() {
        Queue<class_2338> frontier = new LinkedList<>();
        List<ChassisBlockEntity> collected = new ArrayList<>();
        Set<class_2338> visited = new HashSet<>();
        frontier.add(field_11867);
        while (!frontier.isEmpty()) {
            class_2338 current = frontier.poll();
            if (visited.contains(current))
                continue;
            visited.add(current);
            class_2586 blockEntity = field_11863.method_8321(current);
            if (blockEntity instanceof ChassisBlockEntity chassis) {
                collected.add(chassis);
                visited.add(current);
                chassis.addAttachedChasses(frontier, visited);
            }
        }
        return collected;
    }

    public boolean addAttachedChasses(Queue<class_2338> frontier, Set<class_2338> visited) {
        class_2680 state = method_11010();
        if (!(state.method_26204() instanceof AbstractChassisBlock))
            return false;
        class_2351 axis = state.method_11654(AbstractChassisBlock.field_11459);
        if (isRadial()) {

            // Collect chain of radial chassis
            for (int offset : new int[]{-1, 1}) {
                class_2350 direction = class_2350.method_10156(class_2352.field_11056, axis);
                class_2338 currentPos = field_11867.method_10079(direction, offset);
                if (!field_11863.method_8477(currentPos))
                    return false;

                class_2680 neighbourState = field_11863.method_8320(currentPos);
                if (!neighbourState.method_27852(AllBlocks.RADIAL_CHASSIS))
                    continue;
                if (axis != neighbourState.method_11654(class_2741.field_12496))
                    continue;
                if (!visited.contains(currentPos))
                    frontier.add(currentPos);
            }

            return true;
        }

        // Collect group of connected linear chassis
        for (class_2350 offset : Iterate.directions) {
            class_2338 current = field_11867.method_10093(offset);
            if (visited.contains(current))
                continue;
            if (!field_11863.method_8477(current))
                return false;

            class_2680 neighbourState = field_11863.method_8320(current);
            if (!LinearChassisBlock.isChassis(neighbourState))
                continue;
            if (!LinearChassisBlock.sameKind(state, neighbourState))
                continue;
            if (neighbourState.method_11654(LinearChassisBlock.field_11459) != axis)
                continue;

            frontier.add(current);
        }

        return true;
    }

    private List<class_2338> getIncludedBlockPositionsLinear(class_2350 forcedMovement, boolean visualize) {
        List<class_2338> positions = new ArrayList<>();
        class_2680 state = method_11010();
        AbstractChassisBlock block = (AbstractChassisBlock) state.method_26204();
        class_2351 axis = state.method_11654(AbstractChassisBlock.field_11459);
        class_2350 facing = class_2350.method_10156(class_2352.field_11056, axis);
        int chassisRange = visualize ? currentlySelectedRange : getRange();

        for (int offset : new int[]{1, -1}) {
            if (offset == -1)
                facing = facing.method_10153();
            boolean sticky = state.method_11654(block.getGlueableSide(state, facing));
            for (int i = 1; i <= chassisRange; i++) {
                class_2338 current = field_11867.method_10079(facing, i);
                class_2680 currentState = field_11863.method_8320(current);

                if (forcedMovement != facing && !sticky)
                    break;

                // Ignore replaceable Blocks and Air-like
                if (!BlockMovementChecks.isMovementNecessary(currentState, field_11863, current))
                    break;
                if (BlockMovementChecks.isBrittle(currentState))
                    break;

                positions.add(current);

                if (BlockMovementChecks.isNotSupportive(currentState, facing))
                    break;
            }
        }

        return positions;
    }

    private List<class_2338> getIncludedBlockPositionsRadial(class_2350 forcedMovement, boolean visualize) {
        List<class_2338> positions = new ArrayList<>();
        class_2680 state = field_11863.method_8320(field_11867);
        class_2351 axis = state.method_11654(AbstractChassisBlock.field_11459);
        AbstractChassisBlock block = (AbstractChassisBlock) state.method_26204();
        int chassisRange = visualize ? currentlySelectedRange : getRange();

        for (class_2350 facing : Iterate.directions) {
            if (facing.method_10166() == axis)
                continue;
            if (!state.method_11654(block.getGlueableSide(state, facing)))
                continue;

            class_2338 startPos = field_11867.method_10093(facing);
            List<class_2338> localFrontier = new LinkedList<>();
            Set<class_2338> localVisited = new HashSet<>();
            localFrontier.add(startPos);

            while (!localFrontier.isEmpty()) {
                class_2338 searchPos = localFrontier.remove(0);
                class_2680 searchedState = field_11863.method_8320(searchPos);

                if (localVisited.contains(searchPos))
                    continue;
                if (!searchPos.method_19771(field_11867, chassisRange + .5f))
                    continue;
                if (!BlockMovementChecks.isMovementNecessary(searchedState, field_11863, searchPos))
                    continue;
                if (BlockMovementChecks.isBrittle(searchedState))
                    continue;

                localVisited.add(searchPos);
                if (!searchPos.equals(field_11867))
                    positions.add(searchPos);

                for (class_2350 offset : Iterate.directions) {
                    if (offset.method_10166() == axis)
                        continue;
                    if (searchPos.equals(field_11867) && offset != facing)
                        continue;
                    if (BlockMovementChecks.isNotSupportive(searchedState, offset))
                        continue;

                    localFrontier.add(searchPos.method_10093(offset));
                }
            }
        }

        return positions;
    }
}
