package com.zurrtum.create.content.contraptions.chassis;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.catnip.animation.LerpedFloat.Chaser;
import com.zurrtum.create.compat.computercraft.AbstractComputerBehaviour;
import com.zurrtum.create.compat.computercraft.ComputerCraftProxy;
import com.zurrtum.create.content.contraptions.glue.SuperGlueEntity;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;

public class StickerBlockEntity extends SmartBlockEntity {
    public LerpedFloat piston;
    public boolean update;

    public AbstractComputerBehaviour computerBehaviour;

    public StickerBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.STICKER, pos, state);
        piston = LerpedFloat.linear();
        update = false;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
        behaviours.add(computerBehaviour = ComputerCraftProxy.behaviour(this));
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!field_11863.method_8608())
            return;
        piston.startWithValue(isBlockStateExtended() ? 1 : 0);
    }

    public boolean isBlockStateExtended() {
        class_2680 blockState = method_11010();
        return blockState.method_27852(AllBlocks.STICKER) && blockState.method_11654(StickerBlock.EXTENDED);
    }

    @Override
    public void tick() {
        super.tick();
        if (!field_11863.method_8608())
            return;
        piston.tickChaser();

        if (isAttachedToBlock() && piston.getValue(0) != piston.getValue() && piston.getValue() == 1) {
            AllClientHandle.INSTANCE.spawnSuperGlueParticles(field_11863, field_11867, method_11010().method_11654(StickerBlock.field_10927), true);
            playSound(true);
        }

        if (!update)
            return;
        update = false;
        int target = isBlockStateExtended() ? 1 : 0;
        if (isAttachedToBlock() && target == 0 && piston.getChaseTarget() == 1)
            playSound(false);
        piston.chase(target, .4f, Chaser.LINEAR);

        AllClientHandle.INSTANCE.queueUpdate(this);
    }

    public boolean isAttachedToBlock() {
        class_2680 blockState = method_11010();
        if (!blockState.method_27852(AllBlocks.STICKER))
            return false;
        class_2350 direction = blockState.method_11654(StickerBlock.field_10927);
        return SuperGlueEntity.isValidFace(field_11863, field_11867.method_10093(direction), direction.method_10153());
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        super.read(view, clientPacket);
        if (clientPacket)
            update = true;
    }

    public void playSound(boolean attach) {
        AllSoundEvents.SLIME_ADDED.play(field_11863, AllClientHandle.INSTANCE.getPlayer(), field_11867, 0.35f, attach ? 0.75f : 0.2f);
    }
}
