package com.zurrtum.create.content.contraptions.elevator;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.data.IntAttached;
import com.zurrtum.create.catnip.data.WorldAttached;
import com.zurrtum.create.foundation.utility.BlockHelper;
import org.jetbrains.annotations.Nullable;

import java.util.*;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;

public class ElevatorColumn {

    public static WorldAttached<Map<ColumnCoords, ElevatorColumn>> LOADED_COLUMNS = new WorldAttached<>($ -> new HashMap<>());

    protected class_1936 level;
    protected ColumnCoords coords;
    public List<Integer> contacts;
    protected int targetedYLevel;
    protected boolean isActive;
    protected boolean targetAvailable;

    @Nullable
    public static ElevatorColumn get(class_1936 level, ColumnCoords coords) {
        return LOADED_COLUMNS.get(level).get(coords);
    }

    public static ElevatorColumn getOrCreate(class_1936 level, ColumnCoords coords) {
        return LOADED_COLUMNS.get(level).computeIfAbsent(coords, c -> new ElevatorColumn(level, c));
    }

    public ElevatorColumn(class_1936 level, ColumnCoords coords) {
        this.level = level;
        this.coords = coords;
        contacts = new ArrayList<>();
        targetAvailable = false;
    }

    public void markDirty() {
        for (class_2338 pos : getContacts()) {
            class_2586 blockEntity = level.method_8321(pos);
            if (blockEntity instanceof ElevatorContactBlockEntity ecbe)
                ecbe.method_5431();
        }
    }

    public void floorReached(class_1936 level, String name) {
        getContacts().forEach(p -> {
            if (level.method_8321(p) instanceof ElevatorContactBlockEntity ecbe)
                ecbe.updateDisplayedFloor(name);
        });
    }

    public int namesListVersion;

    public List<IntAttached<Couple<String>>> compileNamesList() {
        return getContacts().stream().map(p -> {
            if (level.method_8321(p) instanceof ElevatorContactBlockEntity ecbe)
                return IntAttached.with(p.method_10264(), ecbe.getNames());
            return null;
        }).filter(Objects::nonNull).toList();
    }

    public void namesChanged() {
        namesListVersion++;
    }

    public Collection<class_2338> getContacts() {
        return contacts.stream().map(this::contactAt).toList();
    }

    public void gatherAll() {
        class_2338.method_20437(contactAt(level.method_31607()), contactAt(level.method_31600()))
            .filter(p -> coords.equals(ElevatorContactBlock.getColumnCoords(level, p))).forEach(p -> level.method_8652(
                p,
                BlockHelper.copyProperties(level.method_8320(p), AllBlocks.ELEVATOR_CONTACT.method_9564()),
                3
            ));
    }

    public class_2338 contactAt(int y) {
        return new class_2338(coords.x, y, coords.z);
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
        markDirty();
        checkEmpty();
    }

    public boolean isActive() {
        return isActive;
    }

    public void target(int yLevel) {
        targetedYLevel = yLevel;
        targetAvailable = true;
    }

    public boolean isTargetAvailable() {
        return targetAvailable;
    }

    public int getTargetedYLevel() {
        return targetedYLevel;
    }

    public void initNames(class_1937 level) {
        Integer prevLevel = null;

        for (int i = 0; i < contacts.size(); i++) {
            Integer y = contacts.get(i);

            class_2338 pos = contactAt(y);
            if (!(level.method_8321(pos) instanceof ElevatorContactBlockEntity ecbe))
                continue;

            Integer currentLevel = null;

            if (!ecbe.shortName.isBlank()) {
                Integer tryValueOf = tryValueOf(ecbe.shortName);
                if (tryValueOf != null)
                    currentLevel = tryValueOf;
                if (currentLevel == null)
                    continue;
            }

            if (prevLevel != null)
                currentLevel = prevLevel + 1;

            Integer nextLevel = null;

            for (int peekI = i + 1; peekI < contacts.size(); peekI++) {
                class_2338 peekPos = contactAt(contacts.get(peekI));
                if (!(level.method_8321(peekPos) instanceof ElevatorContactBlockEntity peekEcbe))
                    continue;
                Integer tryValueOf = tryValueOf(peekEcbe.shortName);
                if (tryValueOf == null)
                    continue;
                if (currentLevel != null && currentLevel >= tryValueOf) {
                    peekEcbe.shortName = "";
                    break;
                }
                nextLevel = tryValueOf;
                break;
            }

            if (currentLevel == null)
                currentLevel = nextLevel != null ? nextLevel - 1 : 0;

            ecbe.updateName(String.valueOf(currentLevel), ecbe.longName);
            prevLevel = currentLevel;
        }

    }

    private static Integer tryValueOf(String floorName) {
        try {
            return Integer.valueOf(floorName, 10);
        } catch (NumberFormatException nfe) {
            return null;
        }
    }

    public void add(class_2338 contactPos) {
        int coord = contactPos.method_10264();
        if (contacts.contains(coord))
            return;
        int index = 0;
        for (; index < contacts.size(); index++)
            if (contacts.get(index) > coord)
                break;
        contacts.add(index, coord);
        namesChanged();
    }

    public void remove(class_2338 contactPos) {
        contacts.remove((Object) contactPos.method_10264());
        checkEmpty();
        namesChanged();
    }

    private void checkEmpty() {
        if (contacts.isEmpty() && !isActive())
            LOADED_COLUMNS.get(level).remove(coords);
    }

    public record ColumnCoords(int x, int z, class_2350 side) {
        public static final Codec<ColumnCoords> CODEC = RecordCodecBuilder.create(instance -> instance.group(
            Codec.INT.fieldOf("x")
                .forGetter(ColumnCoords::x),
            Codec.INT.fieldOf("z").forGetter(ColumnCoords::z),
            class_2350.field_29502.fieldOf("side").forGetter(ColumnCoords::side)
        ).apply(instance, ColumnCoords::new));

        public ColumnCoords relative(class_2338 anchor) {
            return new ColumnCoords(x + anchor.method_10263(), z + anchor.method_10260(), side);
        }
    }

}
