package com.zurrtum.create.content.contraptions.piston;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.catnip.placement.IPlacementHelper;
import com.zurrtum.create.catnip.placement.PlacementHelpers;
import com.zurrtum.create.content.contraptions.piston.MechanicalPistonBlock.PistonState;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.foundation.block.WrenchableDirectionalBlock;
import com.zurrtum.create.foundation.placement.PoleHelper;
import java.util.function.Predicate;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_2350.class_2352;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2741;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5819;

import static com.zurrtum.create.content.contraptions.piston.MechanicalPistonBlock.*;

public class PistonExtensionPoleBlock extends WrenchableDirectionalBlock implements IWrenchable, class_3737 {

    private static final int placementHelperId = PlacementHelpers.register(PlacementHelper.get());

    public PistonExtensionPoleBlock(class_2251 properties) {
        super(properties);
        method_9590(method_9564().method_11657(field_10927, class_2350.field_11036).method_11657(class_2741.field_12508, false));
    }

    @Override
    public class_2680 method_9576(class_1937 worldIn, class_2338 pos, class_2680 state, class_1657 player) {
        class_2351 axis = state.method_11654(field_10927).method_10166();
        class_2350 direction = class_2350.method_10156(class_2352.field_11056, axis);
        class_2338 pistonHead = null;
        class_2338 pistonBase = null;

        for (int modifier : new int[]{1, -1}) {
            for (int offset = modifier; modifier * offset < MechanicalPistonBlock.maxAllowedPistonPoles(); offset += modifier) {
                class_2338 currentPos = pos.method_10079(direction, offset);
                class_2680 block = worldIn.method_8320(currentPos);

                if (isExtensionPole(block) && axis == block.method_11654(field_10927).method_10166())
                    continue;

                if (isPiston(block) && block.method_11654(class_2741.field_12525).method_10166() == axis)
                    pistonBase = currentPos;

                if (isPistonHead(block) && block.method_11654(class_2741.field_12525).method_10166() == axis)
                    pistonHead = currentPos;

                break;
            }
        }

        if (pistonHead != null && pistonBase != null && worldIn.method_8320(pistonHead).method_11654(class_2741.field_12525) == worldIn.method_8320(pistonBase)
            .method_11654(class_2741.field_12525)) {

            final class_2338 basePos = pistonBase;
            class_2338.method_20437(pistonBase, pistonHead).filter(p -> !p.equals(pos) && !p.equals(basePos))
                .forEach(p -> worldIn.method_22352(p, !player.method_68878()));
            worldIn.method_8501(basePos, worldIn.method_8320(basePos).method_11657(MechanicalPistonBlock.STATE, PistonState.RETRACTED));

            if (worldIn.method_8321(basePos) instanceof MechanicalPistonBlockEntity baseBE) {
                baseBE.onLengthBroken();
            }
        }

        return super.method_9576(worldIn, pos, state, player);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 worldIn, class_2338 pos, class_3726 context) {
        return AllShapes.FOUR_VOXEL_POLE.get(state.method_11654(field_10927).method_10166());
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_3610 FluidState = context.method_8045().method_8316(context.method_8037());
        return method_9564().method_11657(field_10927, context.method_8038().method_10153())
            .method_11657(class_2741.field_12508, Boolean.valueOf(FluidState.method_15772() == class_3612.field_15910));
    }

    @Override
    protected class_1269 method_55765(
        class_1799 stack,
        class_2680 state,
        class_1937 level,
        class_2338 pos,
        class_1657 player,
        class_1268 hand,
        class_3965 hitResult
    ) {
        IPlacementHelper placementHelper = PlacementHelpers.get(placementHelperId);
        if (placementHelper.matchesItem(stack) && !player.method_5715())
            return placementHelper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (class_1747) stack.method_7909(), player, hand);

        return class_1269.field_52423;
    }

    @Override
    public class_3610 method_9545(class_2680 state) {
        return state.method_11654(class_2741.field_12508) ? class_3612.field_15910.method_15729(false) : class_3612.field_15906.method_15785();
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> builder) {
        builder.method_11667(class_2741.field_12508);
        super.method_9515(builder);
    }

    @Override
    public class_2680 method_9559(
        class_2680 state,
        class_4538 world,
        class_10225 tickView,
        class_2338 pos,
        class_2350 direction,
        class_2338 neighbourPos,
        class_2680 neighbourState,
        class_5819 random
    ) {
        if (state.method_11654(class_2741.field_12508))
            tickView.method_64312(pos, class_3612.field_15910, class_3612.field_15910.method_15789(world));
        return state;
    }

    @Override
    protected boolean method_9516(class_2680 state, class_10 pathComputationType) {
        return false;
    }

    public static class PlacementHelper extends PoleHelper<class_2350> {

        private static final PlacementHelper instance = new PlacementHelper();

        public static PlacementHelper get() {
            return instance;
        }

        private PlacementHelper() {
            super(state -> state.method_27852(AllBlocks.PISTON_EXTENSION_POLE), state -> state.method_11654(field_10927).method_10166(), field_10927);
        }

        @Override
        public Predicate<class_1799> getItemPredicate() {
            return stack -> stack.method_31574(AllItems.PISTON_EXTENSION_POLE);
        }
    }
}
