package com.zurrtum.create.content.decoration.palettes;

import net.minecraft.class_2350;
import net.minecraft.class_2680;

public class WindowBlock extends ConnectedGlassBlock {

    protected final boolean translucent;

    public WindowBlock(class_2251 settings, boolean translucent) {
        super(settings);
        this.translucent = translucent;
    }

    public WindowBlock(class_2251 settings) {
        this(settings, false);
    }

    public static WindowBlock translucent(class_2251 settings) {
        return new WindowBlock(settings, true);
    }

    public boolean isTranslucent() {
        return translucent;
    }

    @Override
    public boolean method_9522(class_2680 state, class_2680 adjacentBlockState, class_2350 side) {
        if (state.method_26204() == adjacentBlockState.method_26204()) {
            return true;
        }
        if (state.method_26204() instanceof WindowBlock windowBlock && adjacentBlockState.method_26204() instanceof ConnectedGlassBlock) {
            return !windowBlock.isTranslucent() && side.method_10166().method_10179();
        }
        return super.method_9522(state, adjacentBlockState, side);
    }

}
