package com.zurrtum.create.content.decoration.placard;

import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2390;
import net.minecraft.class_243;
import net.minecraft.class_2680;

public class PlacardBlockEntity extends SmartBlockEntity {

    class_1799 heldItem;
    int poweredTicks;

    public PlacardBlockEntity(class_2338 pos, class_2680 state) {
        super(AllBlockEntityTypes.PLACARD, pos, state);
        heldItem = class_1799.field_8037;
        poweredTicks = 0;
    }

    @Override
    public void method_66473(class_2338 pos, class_2680 oldState) {
        if (!heldItem.method_7960()) {
            class_2248.method_9577(field_11863, pos, heldItem);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (field_11863.method_8608())
            return;
        if (poweredTicks == 0)
            return;

        poweredTicks--;
        if (poweredTicks > 0)
            return;

        class_2680 blockState = method_11010();
        field_11863.method_8652(field_11867, blockState.method_11657(PlacardBlock.POWERED, false), class_2248.field_31036);
        PlacardBlock.updateNeighbours(blockState, field_11863, field_11867);
    }

    public class_1799 getHeldItem() {
        return heldItem;
    }

    public void setHeldItem(class_1799 heldItem) {
        this.heldItem = heldItem;
        notifyUpdate();
    }

    @Override
    protected void write(class_11372 view, boolean clientPacket) {
        view.method_71465("PoweredTicks", poweredTicks);
        if (!heldItem.method_7960()) {
            view.method_71468("Item", class_1799.field_24671, heldItem);
        }
        super.write(view, clientPacket);
    }

    @Override
    protected void read(class_11368 view, boolean clientPacket) {
        int prevTicks = poweredTicks;
        poweredTicks = view.method_71424("PoweredTicks", 0);
        heldItem = view.method_71426("Item", class_1799.field_24671).orElse(class_1799.field_8037);
        super.read(view, clientPacket);

        if (clientPacket && prevTicks < poweredTicks)
            spawnParticles();
    }

    private void spawnParticles() {
        class_2680 blockState = method_11010();
        if (!blockState.method_27852(AllBlocks.PLACARD))
            return;

        class_2390 pParticleData = new class_2390(0xff3300, 1);
        class_243 centerOf = VecHelper.getCenterOf(field_11867);
        class_243 normal = class_243.method_24954(PlacardBlock.connectedDirection(blockState).method_62675());
        class_243 offset = VecHelper.axisAlingedPlaneOf(normal);

        for (int i = 0; i < 10; i++) {
            class_243 v = VecHelper.offsetRandomly(class_243.field_1353, field_11863.field_9229, .5f).method_18806(offset).method_1029().method_1021(.45f).method_1019(normal.method_1021(-.45f))
                .method_1019(centerOf);
            field_11863.method_8406(pParticleData, v.field_1352, v.field_1351, v.field_1350, 0, 0, 0);
        }
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour<?>> behaviours) {
    }

}
