package com.zurrtum.create.content.equipment.armor;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.AllAdvancements;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_8051;
import net.minecraft.class_9274;
import net.minecraft.class_9285;

import static com.zurrtum.create.Create.MOD_ID;

public class DivingHelmetItem extends class_1792 {
    public static final class_1304 SLOT = class_1304.field_6169;
    public static final class_1322 SPEED_MODIFIER = new class_1322(
        class_2960.method_60655(MOD_ID, "netherite_diving_mining_speed"),
        4,
        class_1322.class_1323.field_6331
    );

    public DivingHelmetItem(class_1793 settings) {
        super(settings);
    }

    public static class_9285 createAttributeModifiers(class_1741 material) {
        return new class_9285(ImmutableList.<class_9285.class_9287>builder()
            .addAll(material.method_63993(class_8051.field_41934).comp_2393())
            .add(new class_9285.class_9287(
                class_5134.field_51576,
                DivingHelmetItem.SPEED_MODIFIER,
                class_9274.field_49223
            )).build());
    }

    public static class_1799 getWornItem(class_1297 entity) {
        if (!(entity instanceof class_1309 livingEntity)) {
            return class_1799.field_8037;
        }
        class_1799 stack = livingEntity.method_6118(SLOT);
        if (!(stack.method_7909() instanceof DivingHelmetItem)) {
            return class_1799.field_8037;
        }
        return stack;
    }

    public static void breatheInLava(class_3222 player, class_3218 world) {
        class_1799 helmet = getWornItem(player);
        if (helmet.method_7960())
            return;
        if (helmet.method_58407(world.method_48963().method_48817()))
            return;

        List<class_1799> backtanks = BacktankUtil.getAllWithAir(player);
        if (backtanks.isEmpty())
            return;
        AllAdvancements.DIVING_SUIT_LAVA.trigger(player);
        if (backtanks.stream().allMatch(backtank -> backtank.method_58407(world.method_48963().method_48817())))
            return;

        if (world.method_8510() % 20 == 0)
            BacktankUtil.consumeAir(player, backtanks.getFirst(), 1);
    }

    public static boolean breatheUnderwater(class_3222 player, class_3218 world) {
        class_1799 helmet = getWornItem(player);
        if (helmet.method_7960())
            return false;

        List<class_1799> backtanks = BacktankUtil.getAllWithAir(player);
        if (backtanks.isEmpty())
            return false;

        if (world.method_8510() % 20 == 0)
            BacktankUtil.consumeAir(player, backtanks.getFirst(), 1);

        AllAdvancements.DIVING_SUIT.trigger(player);
        return true;
    }
}
