package com.zurrtum.create.content.equipment.clipboard;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.MapCodec;
import com.zurrtum.create.AllBlockEntityTypes;
import com.zurrtum.create.AllClientHandle;
import com.zurrtum.create.AllShapes;
import com.zurrtum.create.api.entity.FakePlayerHandler;
import com.zurrtum.create.content.equipment.wrench.IWrenchable;
import com.zurrtum.create.foundation.block.IBE;
import com.zurrtum.create.foundation.block.ProperWaterloggedBlock;
import net.minecraft.block.*;
import net.minecraft.class_10225;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_2480;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689.class_2690;
import net.minecraft.class_2738;
import net.minecraft.class_2746;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import org.jetbrains.annotations.NotNull;

import java.util.List;

public class ClipboardBlock extends class_2341 implements IBE<ClipboardBlockEntity>, IWrenchable, ProperWaterloggedBlock {

    public static final class_2746 WRITTEN = class_2746.method_11825("written");

    public static final MapCodec<ClipboardBlock> CODEC = method_54094(ClipboardBlock::new);

    public ClipboardBlock(class_2251 pProperties) {
        super(pProperties);
        method_9590(method_9564().method_11657(WATERLOGGED, false).method_11657(WRITTEN, false));
    }

    @Override
    protected void method_9515(class_2690<class_2248, class_2680> pBuilder) {
        super.method_9515(pBuilder.method_11667(WRITTEN, field_11007, field_11177, WATERLOGGED));
    }

    @Override
    public class_2680 method_9605(class_1750 pContext) {
        class_2680 stateForPlacement = super.method_9605(pContext);
        if (stateForPlacement == null)
            return null;
        if (stateForPlacement.method_11654(field_11007) != class_2738.field_12471)
            stateForPlacement = stateForPlacement.method_11657(field_11177, stateForPlacement.method_11654(field_11177).method_10153());
        return withWater(stateForPlacement, pContext).method_11657(WRITTEN, !pContext.method_8041().method_57380().method_57848());
    }

    @Override
    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return (switch (pState.method_11654(field_11007)) {
            case field_12475 -> AllShapes.CLIPBOARD_FLOOR;
            case field_12473 -> AllShapes.CLIPBOARD_CEILING;
            default -> AllShapes.CLIPBOARD_WALL;
        }).get(pState.method_11654(field_11177));
    }

    @Override
    public boolean method_9558(class_2680 pState, class_4538 pLevel, class_2338 pPos) {
        return !pLevel.method_8320(pPos.method_10093(method_10119(pState).method_10153())).method_45474();
    }

    @Override
    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult) {
        if (player.method_5715()) {
            breakAndCollect(state, level, pos, player);
            return class_1269.field_5812;
        }

        return onBlockEntityUse(
            level, pos, cbe -> {
                if (level.method_8608())
                    AllClientHandle.INSTANCE.openClipboardScreen(player, cbe.method_58693(), pos);
                return class_1269.field_5812;
            }
        );
    }

    @Override
    public void method_9606(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_1657 pPlayer) {
        breakAndCollect(pState, pLevel, pPos, pPlayer);
    }

    private void breakAndCollect(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_1657 pPlayer) {
        if (FakePlayerHandler.has(pPlayer))
            return;
        if (pLevel.method_8608())
            return;
        class_1799 cloneItemStack = method_9574(pLevel, pPos, pState, true);
        pLevel.method_22352(pPos, false);
        if (pLevel.method_8320(pPos) != pState) {
            class_1661 inv = pPlayer.method_31548();
            class_1799 selected = inv.method_7391();
            if (selected.method_7960()) {
                inv.method_67531(cloneItemStack);
            } else {
                inv.method_7398(cloneItemStack);
            }
        }
    }

    @Override
    protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        return applyComponentsToDropStack(new class_1799(this), world.method_8321(pos));
    }

    @Override
    public class_2680 method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        if (!(level.method_8321(pos) instanceof ClipboardBlockEntity cbe))
            return state;
        if (level.method_8608() || player.method_68878())
            return state;
        class_2248.method_9577(level, pos, applyComponentsToDropStack(new class_1799(this), cbe));

        return state;
    }

    @Override
    public List<class_1799> method_9560(class_2680 pState, class_8567.class_8568 pBuilder) {
        if (!(pBuilder.method_51876(class_181.field_1228) instanceof ClipboardBlockEntity cbe))
            return super.method_9560(pState, pBuilder);
        class_1799 drop = applyComponentsToDropStack(new class_1799(this), cbe);
        pBuilder.method_51872(class_2480.field_11495, c -> c.accept(drop.method_7972()));
        return ImmutableList.of(drop);
    }

    private class_1799 applyComponentsToDropStack(class_1799 stack, class_2586 blockEntity) {
        if (blockEntity instanceof ClipboardBlockEntity cbe) {
            stack.method_57365(cbe.method_58693());
            return stack;
        }
        return stack;
    }

    @Override
    public class_3610 method_9545(class_2680 pState) {
        return fluidState(pState);
    }

    @Override
    public class_2680 method_9559(
        class_2680 pState,
        class_4538 pLevel,
        class_10225 tickView,
        class_2338 pCurrentPos,
        class_2350 pFacing,
        class_2338 pFacingPos,
        class_2680 pFacingState,
        class_5819 random
    ) {
        updateWater(pLevel, tickView, pState, pCurrentPos);
        return super.method_9559(pState, pLevel, tickView, pCurrentPos, pFacing, pFacingPos, pFacingState, random);
    }

    @Override
    public Class<ClipboardBlockEntity> getBlockEntityClass() {
        return ClipboardBlockEntity.class;
    }

    @Override
    public class_2591<? extends ClipboardBlockEntity> getBlockEntityType() {
        return AllBlockEntityTypes.CLIPBOARD;
    }

    @Override
    protected @NotNull MapCodec<? extends class_2341> method_53969() {
        return field_46280;
    }
}
